/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Tenant;

import com.franchise.Tenant.TenantContextHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class MultiTenantDataSource
extends AbstractRoutingDataSource {
    private final Map<Object, Object> targetDataSources = new ConcurrentHashMap();

    protected Object determineCurrentLookupKey() {
        return TenantContextHolder.getTenantDbName();
    }

    public void afterPropertiesSet() {
        this.setTargetDataSources(this.targetDataSources);
        super.afterPropertiesSet();
    }

    public void addDataSource(String tenantId, DataSource dataSource) {
        this.targetDataSources.put(tenantId, dataSource);
        super.setTargetDataSources(this.targetDataSources);
        super.afterPropertiesSet();
    }

    private DataSource createDataSourceForTenant(String tenantId) {
        return DataSourceBuilder.create().url("jdbc:mysql://162.240.158.75:3306/" + tenantId).username("fuma_dbuser").password("Fuma@01234").driverClassName("com.mysql.cj.jdbc.Driver").build();
    }

    protected DataSource determineTargetDataSource() {
        String tenantId = TenantContextHolder.getTenantDbName();
        if (tenantId == null) {
            return super.determineTargetDataSource();
        }
        if (!this.targetDataSources.containsKey(tenantId)) {
            DataSource newDataSource = this.createDataSourceForTenant(tenantId);
            this.addDataSource(tenantId, newDataSource);
        }
        return (DataSource)this.targetDataSources.get(tenantId);
    }
}

