/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.User;
import com.franchise.Repository.UserRepo;
import com.franchise.Service.UserService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserRepo userrepo;

    public User saveUser(User user) {
        return (User)this.userrepo.save((Object)user);
    }

    public Optional<User> findByEmail(String email) {
        return this.userrepo.findByEmail(email);
    }

    public boolean isActiveUser(String email) {
        Optional userOpt = this.userrepo.findByEmail(email);
        return userOpt.isPresent() && ((User)userOpt.get()).getIsActive() != false;
    }

    public boolean authenticate(String email, String password) {
        Optional userOpt = this.userrepo.findByEmail(email);
        return userOpt.isPresent() && ((User)userOpt.get()).getPassword().equals(password) && ((User)userOpt.get()).getIsActive() != false;
    }

    public List<User> getallusers() {
        return this.userrepo.findAll();
    }

    public Optional<User> findById(Long id) {
        return this.userrepo.findById((Object)id);
    }

    @Transactional
    public Optional<User> updateUser(Long id, User user) {
        return this.userrepo.findById((Object)id).map(existingUser -> {
            existingUser.setPrefix(user.getPrefix());
            existingUser.setFirstname(user.getFirstname());
            return (User)this.userrepo.save(existingUser);
        });
    }

    @Transactional
    public boolean deleteUser(Long id) {
        if (this.userrepo.existsById((Object)id)) {
            this.userrepo.deleteById((Object)id);
            return true;
        }
        return false;
    }

    public User getUserWithRolesAndPermissions(String email) {
        List users = this.userrepo.findByEmailItsPermissions(email);
        if (users.size() == 1) {
            return (User)users.get(0);
        }
        if (users.isEmpty()) {
            return null;
        }
        throw new IllegalStateException("Multiple users found with email: " + email);
    }

    public Optional<String> getUserName(String email) {
        return this.userrepo.getUsernameByEmail(email);
    }
}

