/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.PurchaseReturn;
import com.franchise.Entity.PurchaseReturnItems;
import com.franchise.Entity.StockTransaction;
import com.franchise.Repository.PurchaseReturnRepo;
import com.franchise.Service.IdGenerator;
import com.franchise.Service.PurchaseReturnService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseReturnServiceImpl
implements PurchaseReturnService {
    @Autowired
    private PurchaseReturnRepo purchaseReturnRepo;
    @Autowired
    private IdGenerator idGenerator;

    public PurchaseReturn savePurchaseReturn(PurchaseReturn purchaseReturn) {
        if (purchaseReturn.getPurchaseReturnItems() != null) {
            purchaseReturn.setIdGenerator(this.idGenerator);
            for (PurchaseReturnItems item : purchaseReturn.getPurchaseReturnItems()) {
                item.setPurchaseReturn(purchaseReturn);
            }
        }
        if (purchaseReturn.getStockTransaction() != null) {
            for (StockTransaction stock : purchaseReturn.getStockTransaction()) {
                stock.setPurchaseReturn(purchaseReturn);
            }
        }
        return (PurchaseReturn)this.purchaseReturnRepo.save((Object)purchaseReturn);
    }

    public List<PurchaseReturn> getAllPurchaseReturns() {
        return this.purchaseReturnRepo.findAll();
    }

    public Optional<PurchaseReturn> getPurchaseReturnById(Long id) {
        return this.purchaseReturnRepo.findById((Object)id);
    }

    public PurchaseReturn updatePurchaseReturn(Long id, PurchaseReturn updatedPurchaseReturn) {
        Optional existingOrder = this.purchaseReturnRepo.findById((Object)id);
        if (existingOrder.isPresent()) {
            PurchaseReturn purchaseReturn = (PurchaseReturn)existingOrder.get();
            purchaseReturn.setVendor(updatedPurchaseReturn.getVendor());
            purchaseReturn.setStatus(updatedPurchaseReturn.getStatus());
            purchaseReturn.setAddedBy(updatedPurchaseReturn.getAddedBy());
            purchaseReturn.setReferenceNumber(updatedPurchaseReturn.getReferenceNumber());
            purchaseReturn.setOrderDate(updatedPurchaseReturn.getOrderDate());
            purchaseReturn.setLocation(updatedPurchaseReturn.getLocation());
            purchaseReturn.setTotalItems(updatedPurchaseReturn.getTotalItems());
            purchaseReturn.setTotalShippedItems(updatedPurchaseReturn.getTotalShippedItems());
            purchaseReturn.setAdditionalNotes(updatedPurchaseReturn.getAdditionalNotes());
            if (updatedPurchaseReturn.getPurchaseReturnItems() != null) {
                purchaseReturn.getPurchaseReturnItems().clear();
                purchaseReturn.getPurchaseReturnItems().addAll(updatedPurchaseReturn.getPurchaseReturnItems());
                for (PurchaseReturnItems item : purchaseReturn.getPurchaseReturnItems()) {
                    item.setPurchaseReturn(purchaseReturn);
                }
            }
            if (updatedPurchaseReturn.getStockTransaction() != null) {
                purchaseReturn.getStockTransaction().clear();
                purchaseReturn.getStockTransaction().addAll(updatedPurchaseReturn.getStockTransaction());
                for (StockTransaction stock : purchaseReturn.getStockTransaction()) {
                    stock.setPurchaseReturn(purchaseReturn);
                }
            }
            return (PurchaseReturn)this.purchaseReturnRepo.save((Object)purchaseReturn);
        }
        return null;
    }

    public void deletePurchaseReturn(Long id) {
        if (this.purchaseReturnRepo.existsById((Object)id)) {
            this.purchaseReturnRepo.deleteById((Object)id);
        }
    }

    public List<String> getAllReturnIds() {
        return this.purchaseReturnRepo.findAll().stream().map(PurchaseReturn::getPurchaseReturnId).collect(Collectors.toList());
    }

    public Optional<PurchaseReturn> getPurchaseReturnByPRId(String purchaseReturnId) {
        return Optional.ofNullable(this.purchaseReturnRepo.findByPurchaseReturnId(purchaseReturnId));
    }

    public List<String> getPurchaseReturnIdsByStatus(Long status) {
        return this.purchaseReturnRepo.findPurchaseReturnIdsByStatus(status);
    }

    public List<PurchaseReturn> getPendingOrders() {
        return this.purchaseReturnRepo.findByPurchaseReturnStatus(Long.valueOf(0L));
    }

    public List<PurchaseReturn> getAcceptedOrders() {
        return this.purchaseReturnRepo.findByPurchaseReturnStatus(Long.valueOf(1L));
    }

    public List<PurchaseReturn> getRejectedOrders() {
        return this.purchaseReturnRepo.findByPurchaseReturnStatus(Long.valueOf(2L));
    }

    public List<PurchaseReturn> getShipOrders() {
        return this.purchaseReturnRepo.findByPurchaseReturnStatus(Long.valueOf(3L));
    }

    public Long getTotalShippedItems(String purchaseReturnId) {
        return this.purchaseReturnRepo.getTotalShippedItems(purchaseReturnId);
    }
}

