/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.OrderItems;
import com.franchise.Entity.PurchaseOrder;
import com.franchise.Repository.PurchaseOrderRepo;
import com.franchise.Service.IdGenerator;
import com.franchise.Service.PurchaseOrderService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseOrderServiceImpl
implements PurchaseOrderService {
    @Autowired
    private PurchaseOrderRepo purchaseOrderRepo;
    @Autowired
    private IdGenerator idGenerator;

    public PurchaseOrder savePurchaseOrder(PurchaseOrder purchaseOrder) {
        if (purchaseOrder.getOrderItems() != null) {
            purchaseOrder.setIdGenerator(this.idGenerator);
            for (OrderItems item : purchaseOrder.getOrderItems()) {
                item.setPurchaseOrder(purchaseOrder);
            }
        }
        return (PurchaseOrder)this.purchaseOrderRepo.save((Object)purchaseOrder);
    }

    public List<PurchaseOrder> getAllPurchaseOrders() {
        return this.purchaseOrderRepo.findAll();
    }

    public Optional<PurchaseOrder> getPurchaseOrderById(Long id) {
        return this.purchaseOrderRepo.findById((Object)id);
    }

    public PurchaseOrder updatePurchaseOrder(Long id, PurchaseOrder updatedPurchaseOrder) {
        Optional existingOrder = this.purchaseOrderRepo.findById((Object)id);
        if (existingOrder.isPresent()) {
            PurchaseOrder purchaseOrder = (PurchaseOrder)existingOrder.get();
            purchaseOrder.setVendor(updatedPurchaseOrder.getVendor());
            purchaseOrder.setStatus(updatedPurchaseOrder.getStatus());
            purchaseOrder.setAddedBy(updatedPurchaseOrder.getAddedBy());
            purchaseOrder.setReferenceNumber(updatedPurchaseOrder.getReferenceNumber());
            purchaseOrder.setOrderDate(updatedPurchaseOrder.getOrderDate());
            purchaseOrder.setLocation(updatedPurchaseOrder.getLocation());
            purchaseOrder.setFile(updatedPurchaseOrder.getFile());
            purchaseOrder.setTotalItems(updatedPurchaseOrder.getTotalItems());
            purchaseOrder.setTotalShippedItems(updatedPurchaseOrder.getTotalShippedItems());
            purchaseOrder.setAdditionalNotes(updatedPurchaseOrder.getAdditionalNotes());
            purchaseOrder.getOrderItems().clear();
            purchaseOrder.getOrderItems().addAll(updatedPurchaseOrder.getOrderItems());
            for (OrderItems item : purchaseOrder.getOrderItems()) {
                item.setPurchaseOrder(purchaseOrder);
            }
            return (PurchaseOrder)this.purchaseOrderRepo.save((Object)purchaseOrder);
        }
        return null;
    }

    public void deletePurchaseOrder(Long id) {
        if (this.purchaseOrderRepo.existsById((Object)id)) {
            this.purchaseOrderRepo.deleteById((Object)id);
        }
    }

    public List<String> getAllOrderIds() {
        return this.purchaseOrderRepo.findAll().stream().map(PurchaseOrder::getPurchaseOrderId).collect(Collectors.toList());
    }

    public Optional<PurchaseOrder> getPurchaseOrderByPoId(String purchaseOrderId) {
        return Optional.ofNullable(this.purchaseOrderRepo.findByPurchaseOrderId(purchaseOrderId));
    }

    public List<String> getPurchaseOrderIdsByStatus(Long status) {
        return this.purchaseOrderRepo.findPurchaseOrderIdsByStatus(status);
    }

    public List<PurchaseOrder> getPendingOrders() {
        return this.purchaseOrderRepo.findByPurchaseStatus(Long.valueOf(0L));
    }

    public List<PurchaseOrder> getAcceptedOrders() {
        return this.purchaseOrderRepo.findByPurchaseStatus(Long.valueOf(1L));
    }

    public List<PurchaseOrder> getRejectedOrders() {
        return this.purchaseOrderRepo.findByPurchaseStatus(Long.valueOf(2L));
    }

    public List<PurchaseOrder> getShipOrders() {
        return this.purchaseOrderRepo.findByPurchaseStatus(Long.valueOf(3L));
    }

    public Long getTotalShippedItems(String purchaseOrderId) {
        return this.purchaseOrderRepo.getTotalShippedItems(purchaseOrderId);
    }
}

