/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Entity;

import com.franchise.Entity.SaleItems;
import com.franchise.Entity.StockTransaction;
import com.franchise.Service.IdGenerator;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;

@Entity
public class Sale {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String customer;
    private Long payTermNumber;
    private String referenceNumber;
    private String location;
    private String payTermType;
    private Date saleDate;
    private String invoiceNo;
    private String discountType;
    private BigDecimal discountAmount;
    private String saleTax;
    private BigDecimal taxAmount;
    private String saleNotes;
    private String saleOrderId;
    private BigDecimal netTotalAmount;
    private Long netTotalUnit;
    private String shippingDetails;
    private BigDecimal shippingCharges;
    private String shippingStatus;
    private String deliveredTo;
    private String deliveryPerson;
    @OneToMany(mappedBy="sale", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SaleItems> saleItems;
    @OneToMany(mappedBy="sale", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<StockTransaction> stockTransaction;
    @Transient
    private IdGenerator idGenerator;

    public List<SaleItems> getSaleItems() {
        return this.saleItems;
    }

    public void setSaleItems(List<SaleItems> saleItems) {
        this.saleItems = saleItems;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public Long getPayTermNumber() {
        return this.payTermNumber;
    }

    public void setPayTermNumber(Long payTermNumber) {
        this.payTermNumber = payTermNumber;
    }

    public String getPayTermType() {
        return this.payTermType;
    }

    public void setPayTermType(String payTermType) {
        this.payTermType = payTermType;
    }

    public Long getNetTotalUnit() {
        return this.netTotalUnit;
    }

    public void setNetTotalUnit(Long netTotalUnit) {
        this.netTotalUnit = netTotalUnit;
    }

    public BigDecimal getNetTotalAmount() {
        return this.netTotalAmount;
    }

    public void setNetTotalAmount(BigDecimal netTotalAmount) {
        this.netTotalAmount = netTotalAmount;
    }

    public Date getSaleDate() {
        return this.saleDate;
    }

    public void setSaleDate(Date saleDate) {
        this.saleDate = saleDate;
    }

    public String getInvoiceNo() {
        return this.invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getDiscountType() {
        return this.discountType;
    }

    public void setDiscountType(String discountType) {
        this.discountType = discountType;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public String getSaleTax() {
        return this.saleTax;
    }

    public void setSaleTax(String saleTax) {
        this.saleTax = saleTax;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getSaleNotes() {
        return this.saleNotes;
    }

    public void setSaleNotes(String saleNotes) {
        this.saleNotes = saleNotes;
    }

    public String getShippingDetails() {
        return this.shippingDetails;
    }

    public void setShippingDetails(String shippingDetails) {
        this.shippingDetails = shippingDetails;
    }

    public BigDecimal getShippingCharges() {
        return this.shippingCharges;
    }

    public void setShippingCharges(BigDecimal shippingCharges) {
        this.shippingCharges = shippingCharges;
    }

    public String getShippingStatus() {
        return this.shippingStatus;
    }

    public void setShippingStatus(String shippingStatus) {
        this.shippingStatus = shippingStatus;
    }

    public String getDeliveredTo() {
        return this.deliveredTo;
    }

    public void setDeliveredTo(String deliveredTo) {
        this.deliveredTo = deliveredTo;
    }

    public String getDeliveryPerson() {
        return this.deliveryPerson;
    }

    public void setDeliveryPerson(String deliveryPerson) {
        this.deliveryPerson = deliveryPerson;
    }

    public String getSaleOrderId() {
        return this.saleOrderId;
    }

    public void setSaleOrderId(String saleOrderId) {
        this.saleOrderId = saleOrderId;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @PrePersist
    private void generateSaleOrderId() {
        if (this.saleOrderId == null && this.idGenerator != null) {
            this.saleOrderId = this.idGenerator.generateSaleOrderId();
        }
    }

    public List<StockTransaction> getStockTransaction() {
        return this.stockTransaction;
    }

    public void setStockTransaction(List<StockTransaction> stockTransaction) {
        this.stockTransaction = stockTransaction;
    }
}

