/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Entity;

import com.franchise.Entity.PurchaseReturnItems;
import com.franchise.Entity.StockTransaction;
import com.franchise.Service.IdGenerator;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Transient;
import java.sql.Date;
import java.util.List;

@Entity
public class PurchaseReturn {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String purchaseReturnId;
    private Long status;
    private String vendor;
    private String addedBy;
    private String referenceNumber;
    private Date orderDate;
    private String location;
    private String file;
    private Long totalItems;
    private Long totalAmount;
    private double subtotal;
    private double totalTax;
    private Long totalShippedItems;
    private String additionalNotes;
    @OneToMany(mappedBy="purchaseReturn", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PurchaseReturnItems> purchaseReturnItems;
    @OneToMany(mappedBy="purchaseReturn", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<StockTransaction> stockTransaction;
    @Transient
    private IdGenerator idGenerator;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPurchaseReturnId() {
        return this.purchaseReturnId;
    }

    public void setPurchaseReturnId(String purchaseReturnId) {
        this.purchaseReturnId = purchaseReturnId;
    }

    public Long getStatus() {
        return this.status;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getAddedBy() {
        return this.addedBy;
    }

    public void setAddedBy(String addedBy) {
        this.addedBy = addedBy;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public Date getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public Long getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(Long totalItems) {
        this.totalItems = totalItems;
    }

    public Long getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Long totalAmount) {
        this.totalAmount = totalAmount;
    }

    public double getSubtotal() {
        return this.subtotal;
    }

    public void setSubtotal(double subtotal) {
        this.subtotal = subtotal;
    }

    public double getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(double totalTax) {
        this.totalTax = totalTax;
    }

    public Long getTotalShippedItems() {
        return this.totalShippedItems;
    }

    public void setTotalShippedItems(Long totalShippedItems) {
        this.totalShippedItems = totalShippedItems;
    }

    public String getAdditionalNotes() {
        return this.additionalNotes;
    }

    public void setAdditionalNotes(String additionalNotes) {
        this.additionalNotes = additionalNotes;
    }

    public List<PurchaseReturnItems> getPurchaseReturnItems() {
        return this.purchaseReturnItems;
    }

    public void setPurchaseReturnItems(List<PurchaseReturnItems> purchaseReturnItems) {
        this.purchaseReturnItems = purchaseReturnItems;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @PrePersist
    private void generatePurchaseReturnId() {
        if (this.purchaseReturnId == null && this.idGenerator != null) {
            this.purchaseReturnId = this.idGenerator.generatePurchaseReturnId();
        }
    }

    public List<StockTransaction> getStockTransaction() {
        return this.stockTransaction;
    }

    public void setStockTransaction(List<StockTransaction> stockTransaction) {
        this.stockTransaction = stockTransaction;
    }
}

