/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Tenant.TenantContextHolder;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class TenantConnectionController {
    @PostMapping(value={"/connect"})
    public ResponseEntity<String> connectToTenant(@RequestBody Map<String, String> body) {
        String tenantDb = body.get("tenantDbName");
        if (tenantDb == null || tenantDb.isEmpty()) {
            return ResponseEntity.badRequest().body((Object)"Missing tenantDbName");
        }
        return ResponseEntity.ok((Object)("Tenant connection ready for: " + tenantDb));
    }

    @GetMapping(value={"/debug"})
    public ResponseEntity<String> getCurrentTenant() {
        String db = TenantContextHolder.getTenantDbName();
        return ResponseEntity.ok((Object)("Current tenant DB: " + db));
    }
}

