/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.SaleReturn;
import com.franchise.Service.SaleReturnService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/saleReturn"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class SaleReturnController {
    @Autowired
    private SaleReturnService saleReturnService;

    public SaleReturnController(SaleReturnService saleReturnService) {
        this.saleReturnService = saleReturnService;
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<SaleReturn> createSale(@RequestBody SaleReturn saleReturn) {
        SaleReturn savedOrderSale = this.saleReturnService.saveSaleReturn(saleReturn);
        return new ResponseEntity((Object)savedOrderSale, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<SaleReturn>> getAllSales() {
        List orders = this.saleReturnService.getAllSaleReturn();
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Optional<SaleReturn>> getSaleOrderById(@PathVariable Long id) {
        Optional orders = this.saleReturnService.getSaleReturnById(id);
        return orders.isPresent() ? new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<SaleReturn> updateSaleSoOrder(@PathVariable Long id, @RequestBody SaleReturn saleReturn) {
        SaleReturn updatedOrder = this.saleReturnService.updateSaleReturn(id, saleReturn);
        if (updatedOrder != null) {
            return ResponseEntity.ok((Object)updatedOrder);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePurchaseOrder(@PathVariable Long id) {
        this.saleReturnService.deleteSaleReturn(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/getAllOrderIds"})
    public ResponseEntity<List<String>> getAllOrderIds() {
        List orderIds = this.saleReturnService.getAllReturnIds();
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getSaleDataById/{id}"})
    public ResponseEntity<SaleReturn> getSaleDataById(@PathVariable String id) {
        Optional order = this.saleReturnService.getSaleOrderById(id);
        return order.map(value -> new ResponseEntity(value, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }
}

