/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.Purchase;
import com.franchise.Service.PurchaseService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/purchase"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class PurchaseController {
    @Autowired
    private PurchaseService purchaseService;

    @PostMapping(value={"/save"})
    public ResponseEntity<Purchase> createPurchase(@RequestBody Purchase purchase) {
        Purchase newPurchase = this.purchaseService.createPurchase(purchase);
        return ResponseEntity.ok((Object)newPurchase);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Purchase>> getAllPurchases() {
        List purchases = this.purchaseService.getAllPurchases();
        return ResponseEntity.ok((Object)purchases);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Purchase> getPurchaseById(@PathVariable Long id) {
        Optional purchase = this.purchaseService.getPurchaseById(id);
        return purchase.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Purchase> updatePurchase(@PathVariable Long id, @RequestBody Purchase purchaseDetails) {
        try {
            Purchase updatedPurchase = this.purchaseService.updatePurchase(id, purchaseDetails);
            return ResponseEntity.ok((Object)updatedPurchase);
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePurchase(@PathVariable Long id) {
        try {
            this.purchaseService.deletePurchase(id);
            return ResponseEntity.noContent().build();
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }
}

