/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.Product;
import com.franchise.Service.ProductService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/product"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class ProductController {
    @Autowired
    private ProductService productService;

    @PostMapping(value={"/save"})
    public ResponseEntity<?> saveProduct(@RequestBody Product product) {
        if (this.productService.existsByAllFields(product.getProductId(), product.getVariationId(), product.getProductName(), product.getVariationName())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)"Product with same Product ID, Variation ID, Product Name and Variation Name already exists.");
        }
        Product saved = this.productService.saveProduct(product);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)saved);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<?> updateProduct(@PathVariable Long id, @RequestBody Product product) {
        Product updated = this.productService.updateProduct(id, product);
        if (updated == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Product not found.");
        }
        return ResponseEntity.ok((Object)updated);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<?> deleteProduct(@PathVariable Long id) {
        this.productService.deleteProduct(id);
        return ResponseEntity.ok((Object)"Product deleted successfully.");
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Product> getById(@PathVariable Long id) {
        Optional product = this.productService.getProductById(id);
        return product.map(ResponseEntity::ok).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Product not found"));
    }

    @GetMapping(value={"/all"})
    public List<Product> getAllProducts() {
        return this.productService.getAllProducts();
    }

    @GetMapping(value={"/by-product-id/{productId}"})
    public List<Product> getByProductId(@PathVariable Long productId) {
        return this.productService.findByProductId(productId);
    }

    @GetMapping(value={"/by-variation-id/{variationId}"})
    public List<Product> getByVariationId(@PathVariable Long variationId) {
        return this.productService.findByVariationId(variationId);
    }

    @GetMapping(value={"/by-product-name/{productName}"})
    public List<Product> getByProductName(@PathVariable String productName) {
        return this.productService.findByProductName(productName);
    }

    @GetMapping(value={"/by-variation-name/{variationName}"})
    public List<Product> getByVariationName(@PathVariable String variationName) {
        return this.productService.findByVariationName(variationName);
    }

    @GetMapping(value={"/check-exists"})
    public ResponseEntity<?> checkIfExists(@RequestParam Long productId, @RequestParam Long variationId, @RequestParam String productName, @RequestParam String variationName) {
        boolean exists = this.productService.existsByAllFields(productId, variationId, productName, variationName);
        return ResponseEntity.ok((Object)(exists ? "Product already exists." : "Product does not exist."));
    }
}

