/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.Customer;
import com.franchise.Service.CustomerService;
import com.franchise.Tenant.TenantContextHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/customer"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class CustomerController {
    @Autowired
    private CustomerService customerservice;

    @PostMapping(value={"/save"})
    public ResponseEntity<Customer> saveCustomer(@RequestBody Customer customer, @RequestHeader(value="X-TenantID", required=false) String tenantId) {
        if (tenantId != null) {
            TenantContextHolder.setTenantDbName((String)tenantId);
        }
        Customer savedCustomer = this.customerservice.saveCustomer(customer);
        return ResponseEntity.ok((Object)savedCustomer);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Customer>> getAllCustomers(@RequestHeader(value="X-TenantID", required=false) String tenantId) {
        if (tenantId != null) {
            TenantContextHolder.setTenantDbName((String)tenantId);
        }
        List customers = this.customerservice.getAllCustomers();
        return ResponseEntity.ok((Object)customers);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Customer> getCustomerById(@PathVariable Long id, @RequestHeader(value="X-TenantID", required=false) String tenantId) {
        Customer customer;
        if (tenantId != null) {
            TenantContextHolder.setTenantDbName((String)tenantId);
        }
        return (customer = this.customerservice.getCustomerById(id)) != null ? ResponseEntity.ok((Object)customer) : ResponseEntity.notFound().build();
    }

    @PutMapping(value={"update/{id}"})
    public ResponseEntity<Customer> updateCustomer(@PathVariable Long id, @RequestBody Customer updatedCustomer, @RequestHeader(value="X-TenantID", required=false) String tenantId) {
        Customer customer;
        if (tenantId != null) {
            TenantContextHolder.setTenantDbName((String)tenantId);
        }
        return (customer = this.customerservice.updateCustomer(id, updatedCustomer)) != null ? ResponseEntity.ok((Object)customer) : ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteCustomerById(@PathVariable Long id, @RequestHeader(value="X-TenantID", required=false) String tenantId) {
        if (tenantId != null) {
            TenantContextHolder.setTenantDbName((String)tenantId);
        }
        this.customerservice.deleteCustomerById(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/CustomerName/email/{email}"})
    public ResponseEntity<Map<String, String>> getFirmNameByEmail(@PathVariable String email, @RequestHeader(value="X-TenantID", required=false) String tenantId) {
        Optional franchiseName;
        if (tenantId != null) {
            TenantContextHolder.setTenantDbName((String)tenantId);
        }
        if ((franchiseName = this.customerservice.findCustomerByEmail(email)).isPresent()) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("franchiseName", (String)franchiseName.get());
            return ResponseEntity.ok(response);
        }
        return ResponseEntity.notFound().build();
    }
}

