/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.Account;
import com.franchise.Service.AccountService;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class AccountController {
    private final AccountService accountService;

    public AccountController(AccountService accountService) {
        this.accountService = accountService;
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<Account> createAccount(@RequestBody Account account) {
        Account createdAccount = this.accountService.createAccount(account);
        return ResponseEntity.ok((Object)createdAccount);
    }

    @GetMapping(value={"get/{id}"})
    public ResponseEntity<Account> getAccountById(@PathVariable Long id) {
        Optional account = this.accountService.getAccountById(id);
        return account.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value={"update/{id}"})
    public ResponseEntity<Account> updateAccount(@PathVariable Long id, @RequestBody Account account) {
        Account updatedAccount = this.accountService.updateAccount(id, account);
        return updatedAccount != null ? ResponseEntity.ok((Object)updatedAccount) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Account>> getAllAccounts() {
        List accounts = this.accountService.getAllAccounts();
        return ResponseEntity.ok((Object)accounts);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteAccount(@PathVariable Long id) {
        this.accountService.deleteAccount(id);
        return ResponseEntity.noContent().build();
    }
}

