/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.Tax;
import com.backend.Repository.TaxRepository;
import com.backend.Service.TaxService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaxServiceImpl
implements TaxService {
    @Autowired
    private TaxRepository taxRepository;

    public List<Tax> getAllTaxes() {
        return this.taxRepository.findAll();
    }

    public Tax getTaxById(Long id) {
        return (Tax)this.taxRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Tax not found with id: " + id));
    }

    public Tax createTax(Tax tax) {
        return (Tax)this.taxRepository.save((Object)tax);
    }

    public Tax updateTax(Long id, Tax taxDetails) {
        Tax existingTax = (Tax)this.taxRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Tax not found with id: " + id));
        existingTax.setTaxName(taxDetails.getTaxName());
        existingTax.setTaxValue(taxDetails.getTaxValue());
        if (taxDetails.getIncludedTaxes() != null) {
            existingTax.setIncludedTaxes(taxDetails.getIncludedTaxes());
        }
        Tax updatedTax = (Tax)this.taxRepository.save((Object)existingTax);
        List groupTaxes = this.taxRepository.findAll().stream().filter(tax -> tax.getIncludedTaxes() != null && tax.getIncludedTaxes().contains(existingTax)).collect(Collectors.toList());
        for (Tax groupTax : groupTaxes) {
            this.taxRepository.save((Object)groupTax);
        }
        return updatedTax;
    }

    public void deleteTax(Long id) {
        Optional taxOptional = this.taxRepository.findById((Object)id);
        if (taxOptional.isEmpty()) {
            throw new RuntimeException("Tax not found with id: " + id);
        }
        Tax tax = (Tax)taxOptional.get();
        List groupTaxes = this.taxRepository.findAll().stream().filter(t -> t.getIncludedTaxes() != null && t.getIncludedTaxes().contains(tax)).collect(Collectors.toList());
        for (Tax groupTax : groupTaxes) {
            groupTax.getIncludedTaxes().remove(tax);
            this.taxRepository.save((Object)groupTax);
        }
        this.taxRepository.deleteById((Object)id);
    }
}

