/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.StockAdjustment;
import com.backend.Repository.StockAdjustmentRepo;
import com.backend.Service.StockAdjustmentService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StockAdjustmentServiceImpl
implements StockAdjustmentService {
    @Autowired
    private StockAdjustmentRepo stockAdjustmentRepo;

    public StockAdjustment saveStockAdjustment(StockAdjustment stockAdjustment) {
        if (stockAdjustment.getStockAdjustmentItems() != null) {
            stockAdjustment.getStockAdjustmentItems().forEach(item -> item.setStockAdjustment(stockAdjustment));
        }
        if (stockAdjustment.getStockTransaction() != null) {
            stockAdjustment.getStockTransaction().forEach(item -> item.setStockAdjustment(stockAdjustment));
        }
        return (StockAdjustment)this.stockAdjustmentRepo.save((Object)stockAdjustment);
    }

    public List<StockAdjustment> getAllStockAdjustments() {
        return this.stockAdjustmentRepo.findAll();
    }

    public Optional<StockAdjustment> getStockAdjustmentById(Long id) {
        return this.stockAdjustmentRepo.findById((Object)id);
    }

    public StockAdjustment updateStockAdjustment(Long id, StockAdjustment stockAdjustment) {
        Optional existingStockAdjustment = this.stockAdjustmentRepo.findById((Object)id);
        if (existingStockAdjustment.isPresent()) {
            StockAdjustment updatedStockAdjustment = (StockAdjustment)existingStockAdjustment.get();
            updatedStockAdjustment.setBusinessLocation(stockAdjustment.getBusinessLocation());
            updatedStockAdjustment.setReferenceNumber(stockAdjustment.getReferenceNumber());
            updatedStockAdjustment.setDate(stockAdjustment.getDate());
            updatedStockAdjustment.setAdjustmentType(stockAdjustment.getAdjustmentType());
            updatedStockAdjustment.setTotalAmount(stockAdjustment.getTotalAmount());
            updatedStockAdjustment.setTotalUnits(stockAdjustment.getTotalUnits());
            updatedStockAdjustment.setAmountRecovered(stockAdjustment.getAmountRecovered());
            updatedStockAdjustment.setReason(stockAdjustment.getReason());
            if (stockAdjustment.getStockAdjustmentItems() != null) {
                stockAdjustment.getStockAdjustmentItems().forEach(item -> item.setStockAdjustment(updatedStockAdjustment));
                updatedStockAdjustment.setStockAdjustmentItems(stockAdjustment.getStockAdjustmentItems());
            }
            return (StockAdjustment)this.stockAdjustmentRepo.save((Object)updatedStockAdjustment);
        }
        throw new RuntimeException("Stock Adjustment not found with ID: " + id);
    }

    public void deleteStockAdjustment(Long id) {
        if (!this.stockAdjustmentRepo.existsById((Object)id)) {
            throw new RuntimeException("Stock Adjustment not found with ID: " + id);
        }
        this.stockAdjustmentRepo.deleteById((Object)id);
    }
}

