/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.FranchisePurchaseReturn;
import com.backend.Entity.FranchisePurchaseReturnItems;
import com.backend.Entity.StockTransaction;
import com.backend.Repository.FranchisePurchaseReturnRepo;
import com.backend.Service.FranchisePurchaseReturnService;
import com.backend.Service.IdGenerator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FranchisePurchaseReturnServiceImpl
implements FranchisePurchaseReturnService {
    @Autowired
    private FranchisePurchaseReturnRepo repo;
    @Autowired
    private IdGenerator idGenerator;

    public FranchisePurchaseReturn saveFranchisePurchaseReturn(FranchisePurchaseReturn returnOrder) {
        if (returnOrder.getFranchisePurchaseReturnId() == null) {
            returnOrder.setFranchisePurchaseReturnId(this.idGenerator.generateFranchisePurchaseReturnId());
        }
        if (returnOrder.getInvoiceNumber() == null) {
            returnOrder.setInvoiceNumber(this.idGenerator.generateFranchisePurchaseReturnInvoiceNumber());
        }
        if (returnOrder.getFranchisePurchaseReturnItems() != null) {
            for (FranchisePurchaseReturnItems item : returnOrder.getFranchisePurchaseReturnItems()) {
                item.setFranchisePurchaseReturn(returnOrder);
            }
        }
        if (returnOrder.getStockTransactions() != null) {
            for (StockTransaction stock : returnOrder.getStockTransactions()) {
                stock.setFranchisePurchaseReturn(returnOrder);
            }
        }
        return (FranchisePurchaseReturn)this.repo.save((Object)returnOrder);
    }

    public List<FranchisePurchaseReturn> getAllFranchisePurchaseReturns() {
        return this.repo.findAll();
    }

    public Optional<FranchisePurchaseReturn> getFranchisePurchaseReturnById(Long id) {
        return this.repo.findById((Object)id);
    }

    public FranchisePurchaseReturn updateFranchisePurchaseReturn(Long id, FranchisePurchaseReturn updatedReturn) {
        Optional existingOpt = this.repo.findById((Object)id);
        if (existingOpt.isPresent()) {
            FranchisePurchaseReturn existing = (FranchisePurchaseReturn)existingOpt.get();
            existing.setVendor(updatedReturn.getVendor());
            existing.setStatus(updatedReturn.getStatus());
            existing.setPaymentStatus(updatedReturn.getPaymentStatus());
            existing.setAddedBy(updatedReturn.getAddedBy());
            existing.setReferenceNumber(updatedReturn.getReferenceNumber());
            existing.setOrderDate(updatedReturn.getOrderDate());
            existing.setLocation(updatedReturn.getLocation());
            existing.setFile(updatedReturn.getFile());
            existing.setInvoiceNumber(updatedReturn.getInvoiceNumber());
            existing.setFranchiseId(updatedReturn.getFranchiseId());
            existing.setTotalItems(updatedReturn.getTotalItems());
            existing.setCustomerId(updatedReturn.getCustomerId());
            existing.setNetTotalAmount(updatedReturn.getNetTotalAmount());
            existing.setTotalShippedItems(updatedReturn.getTotalShippedItems());
            existing.setAdditionalNotes(updatedReturn.getAdditionalNotes());
            existing.getFranchisePurchaseReturnItems().clear();
            if (updatedReturn.getFranchisePurchaseReturnItems() != null) {
                for (FranchisePurchaseReturnItems item : updatedReturn.getFranchisePurchaseReturnItems()) {
                    item.setFranchisePurchaseReturn(existing);
                    existing.getFranchisePurchaseReturnItems().add(item);
                }
            }
            existing.getStockTransactions().clear();
            if (updatedReturn.getStockTransactions() != null) {
                for (StockTransaction stock : updatedReturn.getStockTransactions()) {
                    stock.setFranchisePurchaseReturn(existing);
                    existing.getStockTransactions().add(stock);
                }
            }
            return (FranchisePurchaseReturn)this.repo.save((Object)existing);
        }
        return null;
    }

    public void deleteFranchisePurchaseReturn(Long id) {
        if (this.repo.existsById((Object)id)) {
            this.repo.deleteById((Object)id);
        }
    }

    public List<String> getAllReturnIds() {
        return this.repo.findAll().stream().map(FranchisePurchaseReturn::getFranchisePurchaseReturnId).collect(Collectors.toList());
    }

    public Optional<FranchisePurchaseReturn> getFranchisePurchaseReturnByIdString(String id) {
        return Optional.ofNullable(this.repo.findByFranchisePurchaseReturnId(id));
    }

    public List<String> getReturnIdsByStatus(Long status) {
        return this.repo.findReturnIdsByStatus(status);
    }

    public List<FranchisePurchaseReturn> getPendingReturns() {
        return this.repo.findByReturnStatus(Long.valueOf(0L));
    }

    public List<FranchisePurchaseReturn> getAcceptedReturns() {
        return this.repo.findByReturnStatus(Long.valueOf(1L));
    }

    public List<FranchisePurchaseReturn> getRejectedReturns() {
        return this.repo.findByReturnStatus(Long.valueOf(2L));
    }

    public List<FranchisePurchaseReturn> getShipReturns() {
        return this.repo.findByReturnStatus(Long.valueOf(3L));
    }

    public Long getTotalShippedItems(String purchaseReturnId) {
        return this.repo.getTotalShippedItems(purchaseReturnId);
    }
}

