/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.FranchiseOrderItems;
import com.backend.Entity.FranchisePurchaseOrder;
import com.backend.Repository.FranchisePurchaseOrderRepo;
import com.backend.Service.FranchisePurchaseOrderService;
import com.backend.Service.IdGenerator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FranchisePurchaseOrderServiceImpl
implements FranchisePurchaseOrderService {
    @Autowired
    private FranchisePurchaseOrderRepo franchisePurchaseOrderRepo;
    @Autowired
    private IdGenerator idGenerator;

    public FranchisePurchaseOrder savePurchaseOrder(FranchisePurchaseOrder franchisePurchaseOrder) {
        if (franchisePurchaseOrder.getFranchiseOrderItems() != null) {
            franchisePurchaseOrder.setIdGenerator(this.idGenerator);
            for (FranchiseOrderItems item : franchisePurchaseOrder.getFranchiseOrderItems()) {
                item.setFranchisePurchaseOrder(franchisePurchaseOrder);
            }
        }
        return (FranchisePurchaseOrder)this.franchisePurchaseOrderRepo.save((Object)franchisePurchaseOrder);
    }

    public List<FranchisePurchaseOrder> getAllPurchaseOrders() {
        return this.franchisePurchaseOrderRepo.findAll();
    }

    public Optional<FranchisePurchaseOrder> getPurchaseOrderById(Long id) {
        return this.franchisePurchaseOrderRepo.findById((Object)id);
    }

    public FranchisePurchaseOrder updatePurchaseOrder(Long id, FranchisePurchaseOrder updatedOrder) {
        Optional existingOrder = this.franchisePurchaseOrderRepo.findById((Object)id);
        if (existingOrder.isPresent()) {
            FranchisePurchaseOrder order = (FranchisePurchaseOrder)existingOrder.get();
            order.setVendor(updatedOrder.getVendor());
            order.setStatus(updatedOrder.getStatus());
            order.setAddedBy(updatedOrder.getAddedBy());
            order.setOrderedBy(updatedOrder.getOrderedBy());
            order.setReferenceNumber(updatedOrder.getReferenceNumber());
            order.setOrderDate(updatedOrder.getOrderDate());
            order.setLocation(updatedOrder.getLocation());
            order.setFile(updatedOrder.getFile());
            order.setTotalItems(updatedOrder.getTotalItems());
            order.setTotalShippedItems(updatedOrder.getTotalShippedItems());
            order.setAdditionalNotes(updatedOrder.getAdditionalNotes());
            order.setCustomerId(updatedOrder.getCustomerId());
            order.setFranchiseName(updatedOrder.getFranchiseName());
            order.setDeliveryDate(updatedOrder.getDeliveryDate());
            order.setDispatchStatus(updatedOrder.getDispatchStatus());
            order.getFranchiseOrderItems().clear();
            order.getFranchiseOrderItems().addAll(updatedOrder.getFranchiseOrderItems());
            for (FranchiseOrderItems item : order.getFranchiseOrderItems()) {
                item.setFranchisePurchaseOrder(order);
            }
            return (FranchisePurchaseOrder)this.franchisePurchaseOrderRepo.save((Object)order);
        }
        return null;
    }

    public void deletePurchaseOrder(Long id) {
        if (this.franchisePurchaseOrderRepo.existsById((Object)id)) {
            this.franchisePurchaseOrderRepo.deleteById((Object)id);
        }
    }

    public List<String> getAllOrderIds() {
        return this.franchisePurchaseOrderRepo.findAll().stream().map(FranchisePurchaseOrder::getFranchisePurchaseOrderId).collect(Collectors.toList());
    }

    public Optional<FranchisePurchaseOrder> getPurchaseOrderByPoId(String id) {
        return this.franchisePurchaseOrderRepo.findAll().stream().filter(order -> id.equals(order.getFranchisePurchaseOrderId())).findFirst();
    }

    public List<String> getPurchaseOrderIdsByStatus(Long status) {
        return this.franchisePurchaseOrderRepo.findAll().stream().filter(order -> status.equals(order.getStatus())).map(FranchisePurchaseOrder::getFranchisePurchaseOrderId).collect(Collectors.toList());
    }

    public List<FranchisePurchaseOrder> getPendingOrders() {
        return this.franchisePurchaseOrderRepo.findAll().stream().filter(order -> order.getStatus() != null && order.getStatus() == 0L).collect(Collectors.toList());
    }

    public List<FranchisePurchaseOrder> getAcceptedOrders() {
        return this.franchisePurchaseOrderRepo.findAll().stream().filter(order -> order.getStatus() != null && order.getStatus() == 1L).collect(Collectors.toList());
    }

    public List<FranchisePurchaseOrder> getRejectedOrders() {
        return this.franchisePurchaseOrderRepo.findAll().stream().filter(order -> order.getStatus() != null && order.getStatus() == 2L).collect(Collectors.toList());
    }

    public List<FranchisePurchaseOrder> getShipOrders() {
        return this.franchisePurchaseOrderRepo.findAll().stream().filter(order -> order.getStatus() != null && order.getStatus() == 3L).collect(Collectors.toList());
    }

    public Long getTotalShippedItems(String franchisePurchaseOrderId) {
        return this.franchisePurchaseOrderRepo.findAll().stream().filter(order -> franchisePurchaseOrderId.equals(order.getFranchisePurchaseOrderId())).map(FranchisePurchaseOrder::getTotalShippedItems).findFirst().orElse(0L);
    }

    public FranchisePurchaseOrder updateDispatchStatus(Long id, String dispatchStatus) {
        Optional existingOrder = this.franchisePurchaseOrderRepo.findById((Object)id);
        if (existingOrder.isPresent()) {
            FranchisePurchaseOrder order = (FranchisePurchaseOrder)existingOrder.get();
            order.setDispatchStatus(dispatchStatus);
            return (FranchisePurchaseOrder)this.franchisePurchaseOrderRepo.save((Object)order);
        }
        return null;
    }
}

