/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.Customer;
import com.backend.Repository.CustomerRepo;
import com.backend.Service.CustomerService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerImpl
implements CustomerService {
    @Autowired
    private CustomerRepo customerrepo;

    public Customer saveCustomer(Customer customer) {
        return (Customer)this.customerrepo.save((Object)customer);
    }

    public List<Customer> getAllCustomers() {
        return this.customerrepo.findAll();
    }

    public Customer updateCustomer(Long customerId, Customer updatedCustomer) {
        Optional existingCustomerOptional = this.customerrepo.findById((Object)customerId);
        if (existingCustomerOptional.isPresent()) {
            Customer existingCustomer = (Customer)existingCustomerOptional.get();
            existingCustomer.setPrefix(updatedCustomer.getPrefix());
            existingCustomer.setFirstname(updatedCustomer.getFirstname());
            existingCustomer.setLastname(updatedCustomer.getLastname());
            existingCustomer.setEmail(updatedCustomer.getEmail());
            existingCustomer.setFranchiseId(updatedCustomer.getFranchiseId());
            existingCustomer.setFranchiseName(updatedCustomer.getFranchiseName());
            existingCustomer.setTaxOrGstNumber(updatedCustomer.getTaxOrGstNumber());
            existingCustomer.setShopActNumber(updatedCustomer.getShopActNumber());
            existingCustomer.setCinNumber(updatedCustomer.getCinNumber());
            existingCustomer.setPanNumber(updatedCustomer.getPanNumber());
            existingCustomer.setIsActive(updatedCustomer.getIsActive());
            existingCustomer.setUsername(updatedCustomer.getUsername());
            existingCustomer.setPassword(updatedCustomer.getPassword());
            existingCustomer.setAllowLogin(updatedCustomer.getAllowLogin());
            existingCustomer.setLanguage(updatedCustomer.getLanguage());
            existingCustomer.setDateOfBirth(updatedCustomer.getDateOfBirth());
            existingCustomer.setGender(updatedCustomer.getGender());
            existingCustomer.setMaritalStatus(updatedCustomer.getMaritalStatus());
            existingCustomer.setBloodGroup(updatedCustomer.getBloodGroup());
            existingCustomer.setMobileNumber(updatedCustomer.getMobileNumber());
            existingCustomer.setAlternateContactNumber(updatedCustomer.getAlternateContactNumber());
            existingCustomer.setFamilyContactNumber(updatedCustomer.getFamilyContactNumber());
            existingCustomer.setFacebookLink(updatedCustomer.getFacebookLink());
            existingCustomer.setTwitterLink(updatedCustomer.getTwitterLink());
            existingCustomer.setSocialMedia1(updatedCustomer.getSocialMedia1());
            existingCustomer.setSocialMedia2(updatedCustomer.getSocialMedia2());
            existingCustomer.setCustomField1(updatedCustomer.getCustomField1());
            existingCustomer.setCustomField2(updatedCustomer.getCustomField2());
            existingCustomer.setCustomField3(updatedCustomer.getCustomField3());
            existingCustomer.setCustomField4(updatedCustomer.getCustomField4());
            existingCustomer.setGuardianName(updatedCustomer.getGuardianName());
            existingCustomer.setIdProofName(updatedCustomer.getIdProofName());
            existingCustomer.setIdProofNumber(updatedCustomer.getIdProofNumber());
            existingCustomer.setPermanentAddress(updatedCustomer.getPermanentAddress());
            existingCustomer.setCurrentAddress(updatedCustomer.getCurrentAddress());
            existingCustomer.setCountry(updatedCustomer.getCountry());
            existingCustomer.setState(updatedCustomer.getState());
            existingCustomer.setCity(updatedCustomer.getCity());
            existingCustomer.setZipCode(updatedCustomer.getZipCode());
            existingCustomer.setAccountHolderName(updatedCustomer.getAccountHolderName());
            existingCustomer.setAccountNumber(updatedCustomer.getAccountNumber());
            existingCustomer.setBankName(updatedCustomer.getBankName());
            existingCustomer.setIfsc(updatedCustomer.getIfsc());
            existingCustomer.setBranch(updatedCustomer.getBranch());
            existingCustomer.setTaxPayerId(updatedCustomer.getTaxPayerId());
            return (Customer)this.customerrepo.save((Object)existingCustomer);
        }
        return null;
    }

    public Customer getCustomerById(Long id) {
        Optional customers = this.customerrepo.findById((Object)id);
        return customers.orElse(null);
    }

    public void deleteCustomerById(Long id) {
        this.customerrepo.deleteById((Object)id);
    }

    public boolean isActiveUser(String email) {
        return false;
    }

    public Optional<Customer> findByEmail(String email) {
        return this.customerrepo.findByEmail(email);
    }

    public boolean authenticate(String email, String password) {
        Optional userOpt = this.customerrepo.findByEmail(email);
        return userOpt.isPresent() && ((Customer)userOpt.get()).getPassword().equals(password) && ((Customer)userOpt.get()).getIsActive() != false;
    }

    public Optional<String> getUserName(String email) {
        return Optional.empty();
    }

    public Optional<String> findFirmNameByEmail(String email) {
        return this.customerrepo.findFirmNameByEmail(email);
    }

    public boolean existsByFranchiseId(String franchiseId) {
        return this.customerrepo.existsByFranchiseId(franchiseId);
    }

    public Optional<Customer> findByEmailId(String email) {
        return this.customerrepo.findByEmail(email);
    }

    public boolean existsByEmail(String email) {
        return this.customerrepo.findByEmail(email).isPresent();
    }

    public List<Customer> getAllActiveCustomers() {
        return this.customerrepo.findByIsActiveTrue();
    }

    public List<Customer> getAllInactiveCustomers() {
        return this.customerrepo.findByIsActiveFalse();
    }

    public Customer toggleActiveStatus(Long id, boolean isActive) {
        Optional optionalCustomer = this.customerrepo.findById((Object)id);
        if (optionalCustomer.isPresent()) {
            Customer customer = (Customer)optionalCustomer.get();
            customer.setIsActive(Boolean.valueOf(isActive));
            return (Customer)this.customerrepo.save((Object)customer);
        }
        return null;
    }

    public Optional<Customer> findByFranchiseId(String franchiseId) {
        return this.customerrepo.findByFranchiseId(franchiseId);
    }
}

