/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import Exceptions.ResourceNotFoundException;
import com.backend.Entity.Categories;
import com.backend.Repository.CategoriesRepo;
import com.backend.Service.CategoriesService;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoriesServiceImpl
implements CategoriesService {
    @Autowired
    private CategoriesRepo catrepo;

    public Categories saveCategories(Categories categories) {
        return (Categories)this.catrepo.save((Object)categories);
    }

    public List<Categories> getAll() {
        return this.catrepo.findAll();
    }

    public Optional<Categories> getById(Long id) {
        return this.catrepo.findById((Object)id);
    }

    public void deleteById(Long id) {
        if (!this.catrepo.existsById((Object)id)) {
            throw new ResourceNotFoundException("Category not found with id: " + id);
        }
        this.catrepo.deleteById((Object)id);
    }

    @Transactional
    public Categories updateCategory(Long categoryId, Categories updatedCategory) {
        Categories existingCategory = (Categories)this.catrepo.findById((Object)categoryId).orElseThrow(() -> new ResourceNotFoundException("Category not found"));
        existingCategory.setCategoryName(updatedCategory.getCategoryName());
        existingCategory.setCategoryCode(updatedCategory.getCategoryCode());
        existingCategory.setDescription(updatedCategory.getDescription());
        if (updatedCategory.getParentCategory() != null) {
            Categories parentCategory = (Categories)this.catrepo.findById((Object)updatedCategory.getParentCategory().getId()).orElseThrow(() -> new ResourceNotFoundException("Parent Category not found"));
            existingCategory.setParentCategory(parentCategory);
        } else {
            existingCategory.setParentCategory(null);
        }
        Set currentSubCategories = existingCategory.getSubCategories();
        for (Categories currentSubCategory : currentSubCategories) {
            if (updatedCategory.getSubCategories().contains(currentSubCategory)) continue;
            currentSubCategory.setParentCategory(null);
            existingCategory.getSubCategories().remove(currentSubCategory);
            this.catrepo.delete((Object)currentSubCategory);
        }
        for (Categories newSubCategory : updatedCategory.getSubCategories()) {
            if (newSubCategory.getId() == null || !currentSubCategories.contains(newSubCategory)) {
                newSubCategory.setParentCategory(existingCategory);
                existingCategory.getSubCategories().add(newSubCategory);
                continue;
            }
            Categories existingSubCategory = (Categories)this.catrepo.findById((Object)newSubCategory.getId()).orElseThrow(() -> new ResourceNotFoundException("Subcategory not found"));
            existingSubCategory.setCategoryName(newSubCategory.getCategoryName());
            existingSubCategory.setCategoryCode(newSubCategory.getCategoryCode());
            existingSubCategory.setDescription(newSubCategory.getDescription());
        }
        return (Categories)this.catrepo.save((Object)existingCategory);
    }
}

