/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Entity;

import com.backend.Entity.AddExpenses;
import com.backend.Entity.PaymentAccount;
import com.backend.Entity.PurchaseDIOrder;
import com.backend.Entity.PurchasePoOrder;
import com.backend.Entity.SaleDIOrder;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
public class Transaction {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String paymentMethod;
    private BigDecimal amount;
    private String transactionType;
    private String addedBy;
    private String note;
    private LocalDateTime date;
    private BigDecimal balance;
    private String vendor;
    private String franchiseName;
    private String chequeNumber;
    private String cardType;
    private String cardNumber;
    private String cardHolderName;
    private String cardTransactionNumber;
    private Long cardMonth;
    private Long cardYear;
    private Long cardSecurity;
    private String cashDetails;
    @ManyToOne
    @JoinColumn(name="add_Expenses_id")
    @JsonBackReference
    private AddExpenses addExpenses;
    @ManyToOne
    @JoinColumn(name="purchase_Po_Order_id")
    @JsonBackReference
    @JsonIgnore
    private PurchasePoOrder purchasePoOrder;
    @ManyToOne
    @JoinColumn(name="purchase_DI_Order_id")
    @JsonBackReference
    @JsonIgnore
    private PurchaseDIOrder purchaseDIOrder;
    @ManyToOne
    @JoinColumn(name="sale_DI_Order_id")
    @JsonBackReference
    @JsonIgnore
    private SaleDIOrder saleDIOrder;
    @ManyToOne
    @JoinColumn(name="payment_account_id", nullable=false)
    @JsonBackReference
    @JsonIgnore
    private PaymentAccount paymentAccount;
    @Transient
    private Long paymentAccountId;

    public Long getPaymentAccountId() {
        if (this.paymentAccountId == null && this.paymentAccount != null) {
            return this.paymentAccount.getId();
        }
        return this.paymentAccountId;
    }

    public void setPaymentAccountId(Long paymentAccountId) {
        this.paymentAccountId = paymentAccountId;
    }

    @Transient
    public BigDecimal getDebit() {
        if (this.transactionType == null) {
            return BigDecimal.ZERO;
        }
        switch (this.transactionType.toLowerCase()) {
            case "opening_balance": 
            case "deposit": 
            case "credit note": {
                return this.amount != null ? this.amount : BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    @Transient
    public BigDecimal getCredit() {
        if (this.transactionType == null) {
            return BigDecimal.ZERO;
        }
        switch (this.transactionType.toLowerCase()) {
            case "sale": 
            case "payment": 
            case "expense": {
                return this.amount != null ? this.amount : BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public String getAddedBy() {
        return this.addedBy;
    }

    public void setAddedBy(String addedBy) {
        this.addedBy = addedBy;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public void setDate(LocalDateTime date) {
        this.date = date;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getFranchiseName() {
        return this.franchiseName;
    }

    public void setFranchiseName(String franchiseName) {
        this.franchiseName = franchiseName;
    }

    public String getChequeNumber() {
        return this.chequeNumber;
    }

    public void setChequeNumber(String chequeNumber) {
        this.chequeNumber = chequeNumber;
    }

    public String getCardType() {
        return this.cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public String getCardHolderName() {
        return this.cardHolderName;
    }

    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    public String getCardTransactionNumber() {
        return this.cardTransactionNumber;
    }

    public void setCardTransactionNumber(String cardTransactionNumber) {
        this.cardTransactionNumber = cardTransactionNumber;
    }

    public Long getCardMonth() {
        return this.cardMonth;
    }

    public void setCardMonth(Long cardMonth) {
        this.cardMonth = cardMonth;
    }

    public Long getCardYear() {
        return this.cardYear;
    }

    public void setCardYear(Long cardYear) {
        this.cardYear = cardYear;
    }

    public Long getCardSecurity() {
        return this.cardSecurity;
    }

    public void setCardSecurity(Long cardSecurity) {
        this.cardSecurity = cardSecurity;
    }

    public String getCashDetails() {
        return this.cashDetails;
    }

    public void setCashDetails(String cashDetails) {
        this.cashDetails = cashDetails;
    }

    public PaymentAccount getPaymentAccount() {
        return this.paymentAccount;
    }

    public void setPaymentAccount(PaymentAccount paymentAccount) {
        this.paymentAccount = paymentAccount;
    }

    public PurchasePoOrder getPurchasePoOrder() {
        return this.purchasePoOrder;
    }

    public void setPurchasePoOrder(PurchasePoOrder purchasePoOrder) {
        this.purchasePoOrder = purchasePoOrder;
    }

    public PurchaseDIOrder getPurchaseDIOrder() {
        return this.purchaseDIOrder;
    }

    public void setPurchaseDIOrder(PurchaseDIOrder purchaseDIOrder) {
        this.purchaseDIOrder = purchaseDIOrder;
    }

    public SaleDIOrder getSaleDIOrder() {
        return this.saleDIOrder;
    }

    public AddExpenses getAddExpenses() {
        return this.addExpenses;
    }

    public void setAddExpenses(AddExpenses addExpenses) {
        this.addExpenses = addExpenses;
    }

    public void setSaleDIOrder(SaleDIOrder saleDIOrder) {
        this.saleDIOrder = saleDIOrder;
    }
}

