/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.List;

@Entity
@Table(name="expenses")
public class Expenses {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String expenseName;
    private String expenseCode;
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_id")
    @JsonBackReference
    private Expenses parentExpense;
    @OneToMany(mappedBy="parentExpense", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonManagedReference
    private List<Expenses> subExpenses;

    public Expenses() {
    }

    public Expenses(String expenseName, String expenseCode, String description, Expenses parentExpense) {
        this.expenseName = expenseName;
        this.expenseCode = expenseCode;
        this.description = description;
        this.parentExpense = parentExpense;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getExpenseName() {
        return this.expenseName;
    }

    public void setExpenseName(String expenseName) {
        this.expenseName = expenseName;
    }

    public String getExpenseCode() {
        return this.expenseCode;
    }

    public void setExpenseCode(String expenseCode) {
        this.expenseCode = expenseCode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Expenses getParentExpense() {
        return this.parentExpense;
    }

    public void setParentExpense(Expenses parentExpense) {
        this.parentExpense = parentExpense;
    }

    public List<Expenses> getSubExpenses() {
        return this.subExpenses;
    }

    public void setSubExpenses(List<Expenses> subExpenses) {
        this.subExpenses = subExpenses;
    }
}

