/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Units;
import com.backend.Service.UnitsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/units"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class UnitsController {
    @Autowired
    private UnitsService unitsService;

    @PostMapping(value={"/save"})
    public ResponseEntity<Units> saveUnits(@RequestBody Units units) {
        Units savedUnit = this.unitsService.saveUnits(units);
        return new ResponseEntity((Object)savedUnit, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Units> updateUnits(@PathVariable Long id, @RequestBody Units units) {
        Units existingUnit = this.unitsService.getById(id);
        if (existingUnit != null) {
            units.setId(id);
            Units updatedUnit = this.unitsService.saveUnits(units);
            return new ResponseEntity((Object)updatedUnit, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Units> getById(@PathVariable Long id) {
        Units unit = this.unitsService.getById(id);
        if (unit != null) {
            return new ResponseEntity((Object)unit, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Units>> getAllUnits() {
        List unitsList = this.unitsService.getAllUnits();
        return new ResponseEntity((Object)unitsList, (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteById(@PathVariable Long id) {
        Units unit = this.unitsService.getById(id);
        if (unit != null) {
            this.unitsService.deleteById(id);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

