/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.PurchaseOrder;
import com.backend.Service.PurchaseOrderService;
import com.backend.Util.FileUploadUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/purchaseorder"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class PurchaseOrderController {
    @Autowired
    private PurchaseOrderService purchaseOrderService;
    @Autowired
    private FileUploadUtil fileUploadUtil;

    @PostMapping(value={"/save"})
    public ResponseEntity<PurchaseOrder> createPurchase(@RequestParam(value="purchaseOrder") String purchaseOrderJson, @RequestParam(value="file", required=false) MultipartFile file) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            PurchaseOrder purchaseOrder = (PurchaseOrder)objectMapper.readValue(purchaseOrderJson, PurchaseOrder.class);
            if (file != null && !file.isEmpty()) {
                String fileName = System.currentTimeMillis() + "_" + file.getOriginalFilename();
                String filePath = this.fileUploadUtil.saveFile(fileName, file);
                purchaseOrder.setFile(filePath);
            }
            PurchaseOrder savedOrderPurchase = this.purchaseOrderService.savePurchaseOrder(purchaseOrder);
            return new ResponseEntity((Object)savedOrderPurchase, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (IOException e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<PurchaseOrder> updatePurchaseOrder(@PathVariable Long id, @RequestParam(value="purchaseOrder") String purchaseOrderJson, @RequestParam(value="file", required=false) MultipartFile file) {
        try {
            Optional existingOpt = this.purchaseOrderService.getPurchaseOrderById(id);
            if (!existingOpt.isPresent()) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            PurchaseOrder existingOrder = (PurchaseOrder)existingOpt.get();
            ObjectMapper objectMapper = new ObjectMapper();
            PurchaseOrder updatedOrder = (PurchaseOrder)objectMapper.readValue(purchaseOrderJson, PurchaseOrder.class);
            updatedOrder.setId(id);
            if (file != null && !file.isEmpty()) {
                String fileName = System.currentTimeMillis() + "_" + file.getOriginalFilename();
                String filePath = this.fileUploadUtil.saveFile(fileName, file);
                updatedOrder.setFile(filePath);
            } else {
                updatedOrder.setFile(existingOrder.getFile());
            }
            PurchaseOrder saved = this.purchaseOrderService.updatePurchaseOrder(id, updatedOrder);
            return new ResponseEntity((Object)saved, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IOException e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<PurchaseOrder>> getAllPurchases() {
        List orders = this.purchaseOrderService.getAllPurchaseOrders();
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Optional<PurchaseOrder>> getPurchaseOrderById(@PathVariable Long id) {
        Optional orders = this.purchaseOrderService.getPurchaseOrderById(id);
        return orders.isPresent() ? new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePurchaseOrder(@PathVariable Long id) {
        this.purchaseOrderService.deletePurchaseOrder(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/getAllOrderIds"})
    public ResponseEntity<List<String>> getAllOrderIds() {
        List orderIds = this.purchaseOrderService.getAllOrderIds();
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getPoDataById/{id}"})
    public ResponseEntity<PurchaseOrder> getPurchaseOrderByPoId(@PathVariable String id) {
        Optional order = this.purchaseOrderService.getPurchaseOrderByPoId(id);
        return order.map(value -> new ResponseEntity(value, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/getOrderIdsByStatus/{status}"})
    public ResponseEntity<List<String>> getOrderIdsByStatus(@PathVariable Long status) {
        List orderIds = this.purchaseOrderService.getPurchaseOrderIdsByStatus(status);
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }

    @PutMapping(value={"/updateStatus/{id}"})
    public ResponseEntity<PurchaseOrder> updatePurchaseStatus(@PathVariable Long id, @RequestBody PurchaseOrder updatedStatus) {
        Optional existingOrder = this.purchaseOrderService.getPurchaseOrderById(id);
        if (existingOrder.isPresent()) {
            PurchaseOrder purchaseOrder = (PurchaseOrder)existingOrder.get();
            purchaseOrder.setStatus(updatedStatus.getStatus());
            PurchaseOrder updatedOrder = this.purchaseOrderService.savePurchaseOrder(purchaseOrder);
            return new ResponseEntity((Object)updatedOrder, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/getPendingOrders"})
    public ResponseEntity<List<PurchaseOrder>> getPendingOrders() {
        List pendingOrders = this.purchaseOrderService.getPendingOrders();
        return new ResponseEntity((Object)pendingOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getAcceptedOrders"})
    public ResponseEntity<List<PurchaseOrder>> getAcceptedOrders() {
        List acceptedOrders = this.purchaseOrderService.getAcceptedOrders();
        return new ResponseEntity((Object)acceptedOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getRejectedOrders"})
    public ResponseEntity<List<PurchaseOrder>> getRejectedOrders() {
        List rejectedOrders = this.purchaseOrderService.getRejectedOrders();
        return new ResponseEntity((Object)rejectedOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getShipOrders"})
    public ResponseEntity<List<PurchaseOrder>> getShipOrders() {
        List shipOrders = this.purchaseOrderService.getShipOrders();
        return new ResponseEntity((Object)shipOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getFinalOrders"})
    public ResponseEntity<List<PurchaseOrder>> getFinalOrders() {
        List finalOrders = this.purchaseOrderService.getFinalOrders();
        return new ResponseEntity((Object)finalOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getTotalShippedItems/{purchaseOrderId}"})
    public ResponseEntity<Long> getTotalShippedItems(@PathVariable String purchaseOrderId) {
        Long totalShippedItems = this.purchaseOrderService.getTotalShippedItems(purchaseOrderId);
        return ResponseEntity.ok((Object)totalShippedItems);
    }

    @PutMapping(value={"/updateStatusByOrderId/{purchaseOrderId}"})
    public ResponseEntity<PurchaseOrder> updateStatusByOrderId(@PathVariable String purchaseOrderId, @RequestBody Map<String, Long> requestBody) {
        Long newStatus = requestBody.get("status");
        if (newStatus == null) {
            return ResponseEntity.badRequest().build();
        }
        Optional optionalOrder = this.purchaseOrderService.getPurchaseOrderByPoId(purchaseOrderId);
        if (optionalOrder.isPresent()) {
            PurchaseOrder order = (PurchaseOrder)optionalOrder.get();
            order.setStatus(newStatus);
            PurchaseOrder updatedOrder = this.purchaseOrderService.savePurchaseOrder(order);
            return ResponseEntity.ok((Object)updatedOrder);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
    }
}

