/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Product;
import com.backend.Entity.ProductVariations;
import com.backend.Service.ProductService;
import com.backend.Util.FileUploadUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/product"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class ProductController {
    @Autowired
    private ProductService productService;
    @Autowired
    private FileUploadUtil fileUploadUtil;

    @PostMapping(value={"/save"})
    public ResponseEntity<Product> createProduct(@RequestParam(value="product") String productJson, @RequestParam(value="productImage", required=false) MultipartFile productImage, @RequestParam(value="variationImages", required=false) List<MultipartFile> variationImages) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Product product = (Product)objectMapper.readValue(productJson, Product.class);
        if (productImage != null && !productImage.isEmpty()) {
            String productImagePath = this.fileUploadUtil.saveFile(productImage.getOriginalFilename(), productImage);
            product.setProductImage(productImagePath);
        }
        if (product.getProductVariations() != null) {
            for (int i = 0; i < product.getProductVariations().size(); ++i) {
                MultipartFile variationImage;
                ProductVariations variation = (ProductVariations)product.getProductVariations().get(i);
                if (variationImages == null || i >= variationImages.size() || (variationImage = variationImages.get(i)) == null || variationImage.isEmpty()) continue;
                String variationImagePath = this.fileUploadUtil.saveFile(variationImage.getOriginalFilename(), variationImage);
                variation.setVariationProductImages(variationImagePath);
            }
        }
        Product savedProduct = this.productService.saveProduct(product);
        return new ResponseEntity((Object)savedProduct, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Product> updateProduct(@PathVariable Long id, @RequestParam(value="product") String productJson, @RequestParam(value="productImage", required=false) MultipartFile productImage, @RequestParam(value="variationImages", required=false) List<MultipartFile> variationImages) throws IOException {
        Product existingProduct = this.productService.getProductById(id);
        if (existingProduct == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        Product product = (Product)objectMapper.readValue(productJson, Product.class);
        product.setId(id);
        if (productImage != null && !productImage.isEmpty()) {
            String productImagePath = this.fileUploadUtil.saveFile(productImage.getOriginalFilename(), productImage);
            product.setProductImage(productImagePath);
        } else {
            product.setProductImage(existingProduct.getProductImage());
        }
        if (product.getProductVariations() != null) {
            for (int i = 0; i < product.getProductVariations().size(); ++i) {
                ProductVariations existingVariation;
                ProductVariations variation = (ProductVariations)product.getProductVariations().get(i);
                if (variation.getId() != null && (existingVariation = (ProductVariations)existingProduct.getProductVariations().stream().filter(v -> v.getId().equals(variation.getId())).findFirst().orElse(null)) != null) {
                    if (variationImages != null && i < variationImages.size()) {
                        MultipartFile variationImage = variationImages.get(i);
                        if (variationImage != null && !variationImage.isEmpty()) {
                            String variationImagePath = this.fileUploadUtil.saveFile(variationImage.getOriginalFilename(), variationImage);
                            variation.setVariationProductImages(variationImagePath);
                        } else {
                            variation.setVariationProductImages(existingVariation.getVariationProductImages());
                        }
                    } else {
                        variation.setVariationProductImages(existingVariation.getVariationProductImages());
                    }
                }
                variation.setProduct(product);
            }
        }
        Product updatedProduct = this.productService.updateProduct(id, product);
        return new ResponseEntity((Object)updatedProduct, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Product> getProduct(@PathVariable Long id) {
        Product product = this.productService.getProductById(id);
        if (product != null) {
            return new ResponseEntity((Object)product, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Product>> getAllProducts() {
        List products = this.productService.getAllProducts();
        return new ResponseEntity((Object)products, (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteProduct(@PathVariable Long id) {
        this.productService.deleteProduct(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/details"})
    public ResponseEntity<Product> getProductDetailsByNameAndVariation(@RequestParam(value="productId") Long productId, @RequestParam(value="productVariationId") Long productVariationId) {
        return this.productService.findProductDetailsByIdAndVariation(productId, productVariationId).map(product -> new ResponseEntity(product, (HttpStatusCode)HttpStatus.OK)).orElse(new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/skuExists"})
    public ResponseEntity<Map<String, Boolean>> checkSkuExists(@RequestParam String sku) {
        boolean exists = this.productService.isSkuUnique(sku);
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        response.put("exists", !exists);
        return ResponseEntity.ok(response);
    }

    @PutMapping(value={"/status/{id}"})
    public ResponseEntity<Map<String, Object>> updateProductStatus(@PathVariable Long id, @RequestParam Long status) {
        Product product = this.productService.getProductById(id);
        if (product == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        product.setStatus(status);
        this.productService.updateProductStatus(product);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("message", "Product status updated successfully");
        response.put("productId", id);
        response.put("status", status);
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/getallactive"})
    public ResponseEntity<List<Product>> getActiveProducts() {
        List activeProducts = this.productService.getProductsByStatus(Long.valueOf(1L));
        return ResponseEntity.ok((Object)activeProducts);
    }

    @GetMapping(value={"/getallinactive"})
    public ResponseEntity<List<Product>> getInactiveProducts() {
        List inactiveProducts = this.productService.getProductsByStatus(Long.valueOf(0L));
        return ResponseEntity.ok((Object)inactiveProducts);
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<List<Product>> searchProducts(@RequestParam String query) {
        List products = this.productService.searchProducts(query);
        return ResponseEntity.ok((Object)products);
    }

    @GetMapping(value={"/search/active"})
    public ResponseEntity<List<Product>> searchActiveProducts(@RequestParam String query) {
        List products = this.productService.searchActiveProducts(query);
        return ResponseEntity.ok((Object)products);
    }

    @GetMapping(value={"/search/inactive"})
    public ResponseEntity<List<Product>> searchInactiveProducts(@RequestParam String query) {
        List products = this.productService.searchInactiveProducts(query);
        return ResponseEntity.ok((Object)products);
    }
}

