/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Leave;
import com.backend.Service.LeaveService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/leave"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class LeaveController {
    @Autowired
    private LeaveService leaveService;

    @PostMapping(value={"/add"})
    public ResponseEntity<Leave> saveLeave(@RequestBody Leave leave) {
        Leave savedLeave = this.leaveService.saveLeave(leave);
        return new ResponseEntity((Object)savedLeave, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Leave>> getAllLeaves() {
        List leaves = this.leaveService.getAllLeaves();
        return new ResponseEntity((Object)leaves, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Leave> getLeaveById(@PathVariable Long id) {
        Leave leave = this.leaveService.getLeaveById(id);
        if (leave != null) {
            return new ResponseEntity((Object)leave, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"update/{id}"})
    public ResponseEntity<Leave> updateLeave(@PathVariable Long id, @RequestBody Leave updatedLeave) {
        Leave leave = this.leaveService.updateLeave(id, updatedLeave);
        if (leave != null) {
            return new ResponseEntity((Object)leave, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"delete/{id}"})
    public ResponseEntity<Void> deleteLeaveById(@PathVariable Long id) {
        this.leaveService.deleteLeaveById(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

