/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.FranchisePurchaseReturn;
import com.backend.Entity.PurchaseOrder;
import com.backend.Service.FranchisePurchaseReturnService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/franchise-purchase-return"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class FranchisePurchaseReturnController {
    @Autowired
    private FranchisePurchaseReturnService service;

    @PostMapping(value={"/save"})
    public ResponseEntity<FranchisePurchaseReturn> save(@RequestBody FranchisePurchaseReturn pr) {
        return new ResponseEntity((Object)this.service.saveFranchisePurchaseReturn(pr), (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<FranchisePurchaseReturn>> getAll() {
        return ResponseEntity.ok((Object)this.service.getAllFranchisePurchaseReturns());
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<FranchisePurchaseReturn> getById(@PathVariable Long id) {
        return this.service.getFranchisePurchaseReturnById(id).map(ResponseEntity::ok).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<FranchisePurchaseReturn> update(@PathVariable Long id, @RequestBody FranchisePurchaseReturn pr) {
        FranchisePurchaseReturn updated = this.service.updateFranchisePurchaseReturn(id, pr);
        return updated != null ? ResponseEntity.ok((Object)updated) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> delete(@PathVariable Long id) {
        this.service.deleteFranchisePurchaseReturn(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/getAllOrderIds"})
    public ResponseEntity<List<String>> getAllReturnIds() {
        return ResponseEntity.ok((Object)this.service.getAllReturnIds());
    }

    @GetMapping(value={"/getPoDataById/{id}"})
    public ResponseEntity<FranchisePurchaseReturn> getByStringId(@PathVariable String id) {
        return this.service.getFranchisePurchaseReturnByIdString(id).map(ResponseEntity::ok).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/getOrderIdsByStatus/{status}"})
    public ResponseEntity<List<String>> getByStatus(@PathVariable Long status) {
        return ResponseEntity.ok((Object)this.service.getReturnIdsByStatus(status));
    }

    @PutMapping(value={"/updateStatus/{id}"})
    public ResponseEntity<FranchisePurchaseReturn> updateStatus(@PathVariable Long id, @RequestBody PurchaseOrder updatedStatus) {
        Optional order = this.service.getFranchisePurchaseReturnById(id);
        if (order.isPresent()) {
            FranchisePurchaseReturn pr = (FranchisePurchaseReturn)order.get();
            pr.setStatus(updatedStatus.getStatus());
            return ResponseEntity.ok((Object)this.service.saveFranchisePurchaseReturn(pr));
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/getPendingReturns"})
    public ResponseEntity<List<FranchisePurchaseReturn>> getPending() {
        return ResponseEntity.ok((Object)this.service.getPendingReturns());
    }

    @GetMapping(value={"/getAcceptedReturns"})
    public ResponseEntity<List<FranchisePurchaseReturn>> getAccepted() {
        return ResponseEntity.ok((Object)this.service.getAcceptedReturns());
    }

    @GetMapping(value={"/getRejectedReturns"})
    public ResponseEntity<List<FranchisePurchaseReturn>> getRejected() {
        return ResponseEntity.ok((Object)this.service.getRejectedReturns());
    }

    @GetMapping(value={"/getShipReturns"})
    public ResponseEntity<List<FranchisePurchaseReturn>> getShipped() {
        return ResponseEntity.ok((Object)this.service.getShipReturns());
    }

    @GetMapping(value={"/getTotalShippedItems/{id}"})
    public ResponseEntity<Long> getTotalShipped(@PathVariable String id) {
        return ResponseEntity.ok((Object)this.service.getTotalShippedItems(id));
    }

    @PutMapping(value={"/updatePaymentStatus/{id}"})
    public ResponseEntity<FranchisePurchaseReturn> updatePaymentStatus(@PathVariable Long id, @RequestBody FranchisePurchaseReturn updatedData) {
        Optional order = this.service.getFranchisePurchaseReturnById(id);
        if (order.isPresent()) {
            FranchisePurchaseReturn pr = (FranchisePurchaseReturn)order.get();
            pr.setPaymentStatus(updatedData.getPaymentStatus());
            return ResponseEntity.ok((Object)this.service.saveFranchisePurchaseReturn(pr));
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

