/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FileController {
    private final ResourceLoader resourceLoader;
    @Value(value="${file.upload-dir}")
    private String uploadDir;

    public FileController(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @GetMapping(value={"/uploads/{filename}"})
    public ResponseEntity<Resource> serveFile(@PathVariable String filename) {
        UrlResource resource;
        Path file = Paths.get(this.uploadDir, new String[0]).resolve(filename);
        try {
            resource = new UrlResource(file.toUri());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        if (!resource.exists() || !resource.isReadable()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
        return ResponseEntity.ok().contentType(MediaType.IMAGE_JPEG).body((Object)resource);
    }
}

