/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Expenses;
import com.backend.Service.ExpensesService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/expenses"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class ExpensesController {
    @Autowired
    private ExpensesService expensesService;

    @PostMapping(value={"/save"})
    public ResponseEntity<Expenses> saveExpense(@RequestBody Expenses expense) {
        Expenses savedExpense = this.expensesService.saveExpense(expense);
        return ResponseEntity.ok((Object)savedExpense);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Expenses>> getAllExpenses() {
        return ResponseEntity.ok((Object)this.expensesService.getAllExpenses());
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Expenses> getExpenseById(@PathVariable Long id) {
        Expenses expense = this.expensesService.getExpenseById(id);
        return expense != null ? ResponseEntity.ok((Object)expense) : ResponseEntity.notFound().build();
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Expenses> updateExpense(@PathVariable Long id, @RequestBody Expenses expense) {
        Expenses updatedExpense = this.expensesService.updateExpense(id, expense);
        return updatedExpense != null ? ResponseEntity.ok((Object)updatedExpense) : ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteExpense(@PathVariable Long id) {
        this.expensesService.deleteExpenseById(id);
        return ResponseEntity.noContent().build();
    }
}

