/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Designation;
import com.backend.Service.DesignationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/designation"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class DesignationController {
    @Autowired
    private DesignationService designationService;

    @PostMapping(value={"/add"})
    public ResponseEntity<Designation> createDesignation(@RequestBody Designation designation) {
        Designation savedDesignation = this.designationService.saveDesignation(designation);
        return new ResponseEntity((Object)savedDesignation, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Designation>> getAllDesignations() {
        List designations = this.designationService.getAllDesignations();
        return new ResponseEntity((Object)designations, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Designation> getDesignationById(@PathVariable Long id) {
        try {
            Designation designation = this.designationService.getDesignationById(id);
            return new ResponseEntity((Object)designation, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Designation> updateDesignation(@PathVariable Long id, @RequestBody Designation designation) {
        try {
            Designation updatedDesignation = this.designationService.updateDesignation(id, designation);
            return new ResponseEntity((Object)updatedDesignation, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteDesignationById(@PathVariable Long id) {
        try {
            this.designationService.deleteDesignationById(id);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (Exception e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }
}

