/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Campaign;
import com.backend.Service.CampaignService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/campaign"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class CampaignController {
    @Autowired
    private CampaignService campaignService;

    @PostMapping(value={"/save"})
    public Campaign saveCampaign(@RequestBody Campaign campaign) {
        return this.campaignService.saveCampaign(campaign);
    }

    @GetMapping(value={"/getall"})
    public List<Campaign> getAllCampaigns() {
        return this.campaignService.getAllCampaigns();
    }

    @GetMapping(value={"/get/{id}"})
    public Campaign getCampaignById(@PathVariable Long id) {
        return this.campaignService.getCampaignById(id);
    }

    @PutMapping(value={"/update/{id}"})
    public Campaign updateCampaign(@PathVariable Long id, @RequestBody Campaign campaign) {
        return this.campaignService.updateCampaign(id, campaign);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public void deleteCampaign(@PathVariable Long id) {
        this.campaignService.deleteCampaignById(id);
    }
}

