/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.AddExpenses;
import com.backend.Entity.PaymentAccount;
import com.backend.Entity.Transaction;
import com.backend.Repository.PaymentAccountRepo;
import com.backend.Service.AddExpensesService;
import com.backend.Util.FileUploadUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/add-expenses"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class AddExpensesController {
    @Autowired
    private AddExpensesService addExpensesService;
    @Autowired
    private FileUploadUtil fileUploadUtil;
    @Autowired
    private PaymentAccountRepo paymentAccountRepo;

    @PostMapping(value={"/save"})
    public ResponseEntity<AddExpenses> createExpense(@RequestParam(value="addExpenses") String addExpensesJson, @RequestParam(value="transaction") String transactionJson, @RequestParam(value="file", required=false) MultipartFile file) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.findAndRegisterModules();
            AddExpenses addExpenses = (AddExpenses)mapper.readValue(addExpensesJson, AddExpenses.class);
            Transaction transaction = (Transaction)mapper.readValue(transactionJson, Transaction.class);
            if (file != null && !file.isEmpty()) {
                String fileName = System.currentTimeMillis() + "_" + file.getOriginalFilename();
                String filePath = this.fileUploadUtil.saveFile(fileName, file);
                addExpenses.setFile(filePath);
            }
            transaction.setAddExpenses(addExpenses);
            if (transaction.getPaymentAccountId() != null) {
                PaymentAccount account = (PaymentAccount)this.paymentAccountRepo.findById((Object)transaction.getPaymentAccountId()).orElseThrow(() -> new RuntimeException("Payment Account not found"));
                transaction.setPaymentAccount(account);
            }
            addExpenses.getTransaction().add(transaction);
            AddExpenses saved = this.addExpensesService.saveAddExpenses(addExpenses);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)saved);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.badRequest().build();
        }
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<AddExpenses> updateExpense(@PathVariable Long id, @RequestParam(value="addExpenses") String addExpensesJson, @RequestParam(value="transaction") String transactionJson, @RequestParam(value="file", required=false) MultipartFile file) {
        try {
            AddExpenses existing = (AddExpenses)this.addExpensesService.getAddExpensesById(id).orElseThrow(() -> new RuntimeException("Expense not found"));
            ObjectMapper mapper = new ObjectMapper();
            mapper.findAndRegisterModules();
            AddExpenses updatedExpense = (AddExpenses)mapper.readValue(addExpensesJson, AddExpenses.class);
            updatedExpense.setId(id);
            if (file != null && !file.isEmpty()) {
                String fileName = System.currentTimeMillis() + "_" + file.getOriginalFilename();
                String filePath = this.fileUploadUtil.saveFile(fileName, file);
                updatedExpense.setFile(filePath);
            } else {
                updatedExpense.setFile(existing.getFile());
            }
            Transaction updatedTx = (Transaction)mapper.readValue(transactionJson, Transaction.class);
            if (!existing.getTransaction().isEmpty()) {
                Long oldTxId = ((Transaction)existing.getTransaction().get(0)).getId();
                updatedTx.setId(oldTxId);
            }
            if (updatedTx.getPaymentAccountId() != null) {
                PaymentAccount acc = (PaymentAccount)this.paymentAccountRepo.findById((Object)updatedTx.getPaymentAccountId()).orElseThrow(() -> new RuntimeException("Payment Account not found"));
                updatedTx.setPaymentAccount(acc);
            }
            updatedTx.setAddExpenses(updatedExpense);
            updatedExpense.getTransaction().clear();
            updatedExpense.getTransaction().add(updatedTx);
            AddExpenses saved = this.addExpensesService.updateAddExpenses(id, updatedExpense);
            return new ResponseEntity((Object)saved, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<AddExpenses>> getAllExpenses() {
        return new ResponseEntity((Object)this.addExpensesService.getAllAddExpenses(), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<AddExpenses> getExpenseById(@PathVariable Long id) {
        return this.addExpensesService.getAddExpensesById(id).map(exp -> new ResponseEntity(exp, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteExpense(@PathVariable Long id) {
        this.addExpensesService.deleteAddExpenses(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

