/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Tenant;

import com.franchise.Tenant.MultiTenantConnectionProvider;
import com.franchise.Tenant.TenantContextHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.springframework.stereotype.Component;

@Component
public class MultiTenantConnectionProvider
extends AbstractMultiTenantConnectionProvider<String> {
    private final Map<String, ConnectionProvider> connectionProviders = new ConcurrentHashMap();

    protected ConnectionProvider getAnyConnectionProvider() {
        return this.getConnectionProvider(TenantContextHolder.getTenantDbName());
    }

    protected ConnectionProvider selectConnectionProvider(String tenantIdentifier) {
        return this.getConnectionProvider(tenantIdentifier);
    }

    private ConnectionProvider getConnectionProvider(String tenantId) {
        String dbName = TenantContextHolder.getTenantDbName();
        if (dbName == null || dbName.isEmpty()) {
            throw new IllegalStateException("No tenant database specified");
        }
        return this.connectionProviders.computeIfAbsent(dbName, key -> new SimpleConnectionProvider("jdbc:mysql://162.240.158.75:3306/" + dbName, "fuma_dbuser", "Fuma@01234"));
    }
}

