/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.PaymentMethod;
import com.franchise.Entity.Purchase;
import com.franchise.Repository.PaymentMethodRepo;
import com.franchise.Repository.PurchaseRepo;
import com.franchise.Service.PurchaseService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseServiceImpl
implements PurchaseService {
    @Autowired
    private PurchaseRepo purchaseRepository;
    @Autowired
    private PaymentMethodRepo paymentMethodRepo;

    public Purchase createPurchase(Purchase purchase) {
        if (purchase.getPaymentMethod() != null && purchase.getPaymentMethod().getId() == null) {
            PaymentMethod savedPaymentMethod = (PaymentMethod)this.paymentMethodRepo.save((Object)purchase.getPaymentMethod());
            purchase.setPaymentMethod(savedPaymentMethod);
        }
        return (Purchase)this.purchaseRepository.save((Object)purchase);
    }

    public List<Purchase> getAllPurchases() {
        return this.purchaseRepository.findAll();
    }

    public Optional<Purchase> getPurchaseById(Long id) {
        return this.purchaseRepository.findById((Object)id);
    }

    public Purchase updatePurchase(Long id, Purchase purchaseDetails) {
        Optional existingPurchase = this.purchaseRepository.findById((Object)id);
        if (existingPurchase.isPresent()) {
            Purchase purchase = (Purchase)existingPurchase.get();
            if (purchaseDetails.getPaymentMethod() != null && purchaseDetails.getPaymentMethod().getId() == null) {
                PaymentMethod savedPaymentMethod = (PaymentMethod)this.paymentMethodRepo.save((Object)purchaseDetails.getPaymentMethod());
                purchase.setPaymentMethod(savedPaymentMethod);
            } else {
                purchase.setPaymentMethod(purchaseDetails.getPaymentMethod());
            }
            purchase.setVendor(purchaseDetails.getVendor());
            purchase.setReferenceNumber(purchaseDetails.getReferenceNumber());
            purchase.setStatus(purchaseDetails.getStatus());
            purchase.setAddedBy(purchaseDetails.getAddedBy());
            purchase.setPurchaseDate(purchaseDetails.getPurchaseDate());
            purchase.setLocation(purchaseDetails.getLocation());
            purchase.setFile(purchaseDetails.getFile());
            purchase.setDiscountType(purchaseDetails.getDiscountType());
            purchase.setDiscountAmount(purchaseDetails.getDiscountAmount());
            purchase.setPurchaseTax(purchaseDetails.getPurchaseTax());
            purchase.setTaxAmount(purchaseDetails.getTaxAmount());
            purchase.setAdditionalNotes(purchaseDetails.getAdditionalNotes());
            purchase.setShippingDetails(purchaseDetails.getShippingDetails());
            purchase.setShippingCharges(purchaseDetails.getShippingCharges());
            return (Purchase)this.purchaseRepository.save((Object)purchase);
        }
        throw new RuntimeException("Purchase not found with id " + id);
    }

    public void deletePurchase(Long id) {
        if (!this.purchaseRepository.existsById((Object)id)) {
            throw new RuntimeException("Purchase not found with id " + id);
        }
        this.purchaseRepository.deleteById((Object)id);
    }
}

