/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.PurchasePoItem;
import com.franchise.Entity.PurchasePoOrder;
import com.franchise.Entity.ShippingPoDetails;
import com.franchise.Entity.StockTransaction;
import com.franchise.Repository.PurchasePoOrderRepo;
import com.franchise.Service.PurchasePoOrderService;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchasePoOrderServiceImpl
implements PurchasePoOrderService {
    @Autowired
    private PurchasePoOrderRepo purchaseOrderRepo;

    @Transactional
    public PurchasePoOrder savePurchasePoOrder(PurchasePoOrder purchasePoOrder) {
        if (purchasePoOrder.getPurchasePoItem() != null) {
            for (PurchasePoItem item : purchasePoOrder.getPurchasePoItem()) {
                item.setPurchasePoOrder(purchasePoOrder);
            }
        }
        if (purchasePoOrder.getShippingPoDetails() != null) {
            for (ShippingPoDetails ship : purchasePoOrder.getShippingPoDetails()) {
                ship.setPurchasePoOrder(purchasePoOrder);
            }
        }
        if (purchasePoOrder.getStockTransactions() != null) {
            for (StockTransaction stock : purchasePoOrder.getStockTransactions()) {
                stock.setPurchasePoOrder(purchasePoOrder);
            }
        }
        return (PurchasePoOrder)this.purchaseOrderRepo.save((Object)purchasePoOrder);
    }

    public List<PurchasePoOrder> getAllPurchasePoOrders() {
        return this.purchaseOrderRepo.findAll();
    }

    public Optional<PurchasePoOrder> getPurchasePoOrderById(Long id) {
        return this.purchaseOrderRepo.findById((Object)id);
    }

    public PurchasePoOrder updatePurchasePoOrder(Long id, PurchasePoOrder updatedPurchasePoOrder) {
        Optional existingOrderOptional = this.purchaseOrderRepo.findById((Object)id);
        if (existingOrderOptional.isPresent()) {
            PurchasePoOrder existingOrder = (PurchasePoOrder)existingOrderOptional.get();
            existingOrder.setStatus(updatedPurchasePoOrder.getStatus());
            existingOrder.setVendor(updatedPurchasePoOrder.getVendor());
            existingOrder.setAddedBy(updatedPurchasePoOrder.getAddedBy());
            existingOrder.setOrderedBy(updatedPurchasePoOrder.getOrderedBy());
            existingOrder.setReferenceNumber(updatedPurchasePoOrder.getReferenceNumber());
            existingOrder.setPurchaseReferenceNumber(updatedPurchasePoOrder.getPurchaseReferenceNumber());
            existingOrder.setOrderDate(updatedPurchasePoOrder.getOrderDate());
            existingOrder.setPurchaseDate(updatedPurchasePoOrder.getPurchaseDate());
            existingOrder.setPayTermNumber(updatedPurchasePoOrder.getPayTermNumber());
            existingOrder.setPayTermType(updatedPurchasePoOrder.getPayTermType());
            existingOrder.setLocation(updatedPurchasePoOrder.getLocation());
            existingOrder.setFile(updatedPurchasePoOrder.getFile());
            existingOrder.setTotalItems(updatedPurchasePoOrder.getTotalItems());
            existingOrder.setNetTotalAmount(updatedPurchasePoOrder.getNetTotalAmount());
            existingOrder.setDiscountType(updatedPurchasePoOrder.getDiscountType());
            existingOrder.setDiscountAmount(updatedPurchasePoOrder.getDiscountAmount());
            existingOrder.setPurchaseTax(updatedPurchasePoOrder.getPurchaseTax());
            existingOrder.setTaxAmount(updatedPurchasePoOrder.getTaxAmount());
            existingOrder.setAdditionalNotes(updatedPurchasePoOrder.getAdditionalNotes());
            if (updatedPurchasePoOrder.getPurchasePoItem() != null) {
                existingOrder.getPurchasePoItem().clear();
                for (PurchasePoItem item : updatedPurchasePoOrder.getPurchasePoItem()) {
                    item.setPurchasePoOrder(existingOrder);
                    existingOrder.getPurchasePoItem().add(item);
                }
            }
            if (updatedPurchasePoOrder.getShippingPoDetails() != null) {
                existingOrder.getShippingPoDetails().clear();
                for (ShippingPoDetails shippingDetails : updatedPurchasePoOrder.getShippingPoDetails()) {
                    shippingDetails.setPurchasePoOrder(existingOrder);
                    existingOrder.getShippingPoDetails().add(shippingDetails);
                }
            }
            if (updatedPurchasePoOrder.getStockTransactions() != null) {
                existingOrder.getStockTransactions().clear();
                for (StockTransaction transactions : updatedPurchasePoOrder.getStockTransactions()) {
                    transactions.setPurchasePoOrder(existingOrder);
                    existingOrder.getStockTransactions().add(transactions);
                }
            }
            return (PurchasePoOrder)this.purchaseOrderRepo.save((Object)existingOrder);
        }
        return null;
    }

    public void deletePurchasePoOrder(Long id) {
        if (this.purchaseOrderRepo.existsById((Object)id)) {
            this.purchaseOrderRepo.deleteById((Object)id);
        }
    }

    public List<String> getAllOrderIds() {
        return null;
    }
}

