/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.ProductStock;
import com.franchise.Repository.ProductStockRepo;
import com.franchise.Service.ProductStockService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductStockServiceImpl
implements ProductStockService {
    @Autowired
    private ProductStockRepo productStockRepo;

    public void addProductStock(List<ProductStock> productStocks) {
        for (ProductStock stock : productStocks) {
            Optional existingStock = this.productStockRepo.findByProductIdAndVariationId(stock.getProductId(), stock.getVariationId());
            if (existingStock.isPresent()) {
                ProductStock currentStock = (ProductStock)existingStock.get();
                currentStock.setStockQuantity(stock.getStockQuantity());
                currentStock.setTotalStock(Long.valueOf(currentStock.getTotalStock() + stock.getStockQuantity()));
                this.productStockRepo.save((Object)currentStock);
                continue;
            }
            stock.setTotalStock(stock.getStockQuantity());
            this.productStockRepo.save((Object)stock);
        }
    }

    public ProductStock updateProductStock(Long productId, Long variationId, ProductStock productStock) {
        Optional existingStock = this.productStockRepo.findByProductIdAndVariationId(productId, variationId);
        if (existingStock.isPresent()) {
            ProductStock currentStock = (ProductStock)existingStock.get();
            currentStock.setStockQuantity(productStock.getStockQuantity());
            currentStock.setTotalStock(Long.valueOf(currentStock.getTotalStock() + productStock.getStockQuantity()));
            currentStock.setUnitCostBeforeTax(productStock.getUnitCostBeforeTax());
            currentStock.setSubTotalBeforeTax(productStock.getSubTotalBeforeTax());
            currentStock.setDate(productStock.getDate());
            currentStock.setNote(productStock.getNote());
            return (ProductStock)this.productStockRepo.save((Object)currentStock);
        }
        throw new RuntimeException("Product stock not found with productId: " + productId + " and variationId: " + variationId);
    }

    public void deleteProductStock(Long productId, Long variationId) {
        Optional existingStock = this.productStockRepo.findByProductIdAndVariationId(productId, variationId);
        if (!existingStock.isPresent()) {
            throw new RuntimeException("Product stock not found with productId: " + productId + " and variationId: " + variationId);
        }
        this.productStockRepo.delete((Object)((ProductStock)existingStock.get()));
    }

    public ProductStock getProductStockByProductIdAndVariationId(Long productId, Long variationId) {
        return (ProductStock)this.productStockRepo.findByProductIdAndVariationId(productId, variationId).orElseThrow(() -> new RuntimeException("Product stock not found with productId: " + productId + " and variationId: " + variationId));
    }

    public List<ProductStock> getAllProductStock() {
        return this.productStockRepo.findAll();
    }

    public List<ProductStock> getProductStockByProductId(Long productId) {
        return this.productStockRepo.findByProductId(productId);
    }

    public Long getTotalStockByVariationId(Long variationId) {
        List stocks = this.productStockRepo.findByVariationId(variationId);
        return stocks.stream().mapToLong(ProductStock::getTotalStock).sum();
    }
}

