/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.PaymentAccount;
import com.franchise.Entity.Transaction;
import com.franchise.Repository.PaymentAccountRepo;
import com.franchise.Repository.TransactionRepo;
import com.franchise.Service.PaymentAccountService;
import jakarta.transaction.Transactional;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentAccountServiceImpl
implements PaymentAccountService {
    @Autowired
    private PaymentAccountRepo paymentAccountRepo;
    @Autowired
    private TransactionRepo transactionRepo;

    @Transactional
    public Transaction createTransaction(Long accountId, Transaction transactionRequest) {
        BigDecimal previousBalance;
        PaymentAccount paymentAccount = (PaymentAccount)this.paymentAccountRepo.findById((Object)accountId).orElseThrow(() -> new RuntimeException("Account not found"));
        transactionRequest.setPaymentAccount(paymentAccount);
        BigDecimal newBalance = previousBalance = paymentAccount.getBalance() != null ? paymentAccount.getBalance() : BigDecimal.ZERO;
        switch (transactionRequest.getTransactionType().toLowerCase()) {
            case "deposit": 
            case "purchase": 
            case "salereturn": 
            case "opening_balance": {
                newBalance = previousBalance.add(transactionRequest.getAmount());
                break;
            }
            case "sale": 
            case "expense": {
                newBalance = previousBalance.subtract(transactionRequest.getAmount());
                break;
            }
            default: {
                throw new RuntimeException("Unknown transaction type: " + transactionRequest.getTransactionType());
            }
        }
        transactionRequest.setBalance(newBalance);
        Transaction savedTransaction = (Transaction)this.transactionRepo.save((Object)transactionRequest);
        paymentAccount.setBalance(newBalance);
        this.paymentAccountRepo.save((Object)paymentAccount);
        return savedTransaction;
    }

    public PaymentAccount savePaymentAccount(PaymentAccount paymentAccount) {
        if (paymentAccount.getTransactions() != null && !paymentAccount.getTransactions().isEmpty()) {
            paymentAccount.getTransactions().forEach(transaction -> transaction.setPaymentAccount(paymentAccount));
            BigDecimal balance = BigDecimal.ZERO;
            for (Transaction transaction2 : paymentAccount.getTransactions()) {
                switch (transaction2.getTransactionType().toLowerCase()) {
                    case "deposit": 
                    case "purchase": 
                    case "salereturn": 
                    case "opening_balance": {
                        balance = balance.add(transaction2.getAmount());
                        break;
                    }
                    case "sale": 
                    case "expense": {
                        balance = balance.subtract(transaction2.getAmount());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown transaction type");
                    }
                }
                transaction2.setBalance(balance);
            }
            paymentAccount.setBalance(balance);
        } else if (paymentAccount.getBalance() == null) {
            paymentAccount.setBalance(BigDecimal.ZERO);
        }
        return (PaymentAccount)this.paymentAccountRepo.save((Object)paymentAccount);
    }

    public List<PaymentAccount> getAllPaymentAccounts() {
        return this.paymentAccountRepo.findAll();
    }

    public Optional<PaymentAccount> getPaymentAccountById(Long id) {
        return this.paymentAccountRepo.findById((Object)id);
    }

    public PaymentAccount updatePaymentAccount(Long id, PaymentAccount paymentAccount) {
        Optional existingAccount = this.paymentAccountRepo.findById((Object)id);
        if (existingAccount.isPresent()) {
            PaymentAccount account = (PaymentAccount)existingAccount.get();
            account.setAccountName(paymentAccount.getAccountName());
            account.setAccountNumber(paymentAccount.getAccountNumber());
            account.setAccountType(paymentAccount.getAccountType());
            account.setTransactions(paymentAccount.getTransactions());
            return (PaymentAccount)this.paymentAccountRepo.save((Object)account);
        }
        return null;
    }

    public void deletePaymentAccount(Long id) {
        this.paymentAccountRepo.deleteById((Object)id);
    }

    public BigDecimal getCurrentBalance(Long id) {
        Optional paymentAccountOpt = this.paymentAccountRepo.findById((Object)id);
        if (!paymentAccountOpt.isPresent()) {
            return BigDecimal.ZERO;
        }
        PaymentAccount paymentAccount = (PaymentAccount)paymentAccountOpt.get();
        List transactions = paymentAccount.getTransactions();
        BigDecimal balance = BigDecimal.ZERO;
        for (Transaction trans : transactions) {
            switch (trans.getTransactionType()) {
                case "opening_balance": {
                    balance = balance.add(trans.getAmount());
                    break;
                }
                case "deposit": {
                    balance = balance.add(trans.getAmount());
                    break;
                }
                case "sale": {
                    balance = balance.add(trans.getAmount());
                    break;
                }
                case "purchase": {
                    balance = balance.subtract(trans.getAmount());
                }
            }
        }
        return balance;
    }

    @Transactional
    public Transaction updateTransaction(Long transactionId, BigDecimal amount, String paymentMethod, String transactionType, String addedBy, String note, Date date, String vendor) {
        Transaction existingTransaction = (Transaction)this.transactionRepo.findById((Object)transactionId).orElseThrow(() -> new RuntimeException("Transaction not found"));
        PaymentAccount paymentAccount = existingTransaction.getPaymentAccount();
        if (paymentAccount == null) {
            throw new RuntimeException("Payment Account not found for this transaction");
        }
        BigDecimal previousBalance = paymentAccount.getBalance() != null ? paymentAccount.getBalance() : BigDecimal.ZERO;
        switch (existingTransaction.getTransactionType().toLowerCase()) {
            case "deposit": 
            case "sale": 
            case "opening_balance": {
                previousBalance = previousBalance.subtract(existingTransaction.getAmount());
                break;
            }
            case "purchase": 
            case "expense": {
                previousBalance = previousBalance.add(existingTransaction.getAmount());
                break;
            }
            default: {
                throw new RuntimeException("Unknown transaction type");
            }
        }
        existingTransaction.setAmount(amount);
        existingTransaction.setPaymentMethod(paymentMethod);
        existingTransaction.setTransactionType(transactionType);
        existingTransaction.setAddedBy(addedBy);
        existingTransaction.setNote(note);
        existingTransaction.setVendor(vendor);
        existingTransaction.setDate(date);
        BigDecimal updatedBalance = previousBalance;
        switch (transactionType.toLowerCase()) {
            case "deposit": 
            case "sale": 
            case "opening_balance": {
                updatedBalance = previousBalance.add(amount);
                break;
            }
            case "purchase": 
            case "expense": {
                updatedBalance = previousBalance.subtract(amount);
                break;
            }
            default: {
                throw new RuntimeException("Unknown transaction type");
            }
        }
        existingTransaction.setBalance(updatedBalance);
        Transaction updatedTransaction = (Transaction)this.transactionRepo.save((Object)existingTransaction);
        paymentAccount.setBalance(updatedBalance);
        this.paymentAccountRepo.save((Object)paymentAccount);
        return updatedTransaction;
    }

    @Transactional
    public void updateAccountStatus(Long id, Long status) {
        Optional paymentAccountOpt = this.paymentAccountRepo.findById((Object)id);
        if (!paymentAccountOpt.isPresent()) {
            throw new RuntimeException("Payment Account not found");
        }
        PaymentAccount paymentAccount = (PaymentAccount)paymentAccountOpt.get();
        paymentAccount.setStatus(status);
        this.paymentAccountRepo.save((Object)paymentAccount);
    }

    public Map<String, List<Object>> getPaymentByVendor(String vendorName) {
        HashMap<String, List<Object>> vendorWiseOrders = new HashMap<String, List<Object>>();
        List poOrders = this.transactionRepo.findByVendorName(vendorName);
        vendorWiseOrders.put(vendorName, new ArrayList(poOrders));
        return vendorWiseOrders;
    }
}

