/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Interceptor;

import com.franchise.Tenant.TenantContextHolder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class TenantInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        HttpSession session;
        String tenantDb = request.getHeader("X-TenantID");
        if ((tenantDb == null || tenantDb.isEmpty()) && (session = request.getSession(false)) != null) {
            tenantDb = (String)session.getAttribute("tenantDbName");
        }
        TenantContextHolder.setTenantDbName((String)tenantDb);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        TenantContextHolder.clear();
    }
}

