/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.TaxGroup;
import com.franchise.Service.TaxGroupService;
import com.franchise.Service.TaxRateService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/taxGroup"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class TaxGroupController {
    @Autowired
    private TaxGroupService taxGroupService;
    @Autowired
    private TaxRateService taxRateService;

    @GetMapping(value={"/getall"})
    public List<TaxGroup> getAllTaxGroups() {
        return this.taxGroupService.getAllTaxGroups();
    }

    @PostMapping(value={"/create"})
    public TaxGroup createTaxGroup(@RequestBody TaxGroup taxGroup) {
        List taxRates = this.taxRateService.getTaxRatesByIds(taxGroup.getTaxRatesIds());
        taxGroup.setTaxRates(taxRates);
        return this.taxGroupService.createTaxGroup(taxGroup);
    }

    @PutMapping(value={"/update/{id}"})
    public TaxGroup updateTaxGroup(@PathVariable Long id, @RequestBody TaxGroup taxGroup) {
        List taxRates = this.taxRateService.getTaxRatesByIds(taxGroup.getTaxRatesIds());
        taxGroup.setTaxRates(taxRates);
        return this.taxGroupService.updateTaxGroup(id, taxGroup);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public void deleteTaxGroup(@PathVariable Long id) {
        this.taxGroupService.deleteTaxGroup(id);
    }
}

