/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.StockTransaction;
import com.franchise.Service.StockTransactionService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/stock-transactions"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class StockTransactionController {
    @Autowired
    private StockTransactionService stockTransactionService;

    @PostMapping(value={"/add"})
    public ResponseEntity<List<StockTransaction>> addStockTransactions(@RequestBody List<StockTransaction> stockTransactions) {
        try {
            List savedTransactions = this.stockTransactionService.saveStockTransactions(stockTransactions);
            return new ResponseEntity((Object)savedTransactions, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/by-product/{productId}"})
    public ResponseEntity<List<StockTransaction>> getTransactionsByProduct(@PathVariable Long productId) {
        List transactions = this.stockTransactionService.getTransactionsByProduct(productId);
        if (transactions.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)transactions, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/by-variation/{variationId}"})
    public ResponseEntity<List<StockTransaction>> getTransactionsByVariation(@PathVariable Long variationId) {
        List transactions = this.stockTransactionService.getTransactionsByVariation(variationId);
        if (transactions.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)transactions, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/by-product-variation/{productId}/{variationId}"})
    public ResponseEntity<List<StockTransaction>> getTransactionsByProductAndVariation(@PathVariable Long productId, @PathVariable Long variationId) {
        List transactions = this.stockTransactionService.getTransactionsByProductAndVariation(productId, variationId);
        if (transactions.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)transactions, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/current-stock/{productId}/{variationId}"})
    public ResponseEntity<Integer> getCurrentStock(@PathVariable Long productId, @PathVariable Long variationId) {
        int currentStock = this.stockTransactionService.getCurrentStock(productId, variationId);
        return new ResponseEntity((Object)currentStock, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/current-stock/{productId}"})
    public ResponseEntity<Integer> getCurrentStockByProduct(@PathVariable Long productId) {
        int currentStock = this.stockTransactionService.getCurrentStockByProduct(productId);
        return new ResponseEntity((Object)currentStock, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/current-stock-byvariation/{variationId}"})
    public ResponseEntity<Integer> getcurrentStockByvariation(@PathVariable Long variationId) {
        int currentStock = this.stockTransactionService.getCurrentStockByVariations(variationId);
        return new ResponseEntity((Object)currentStock, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<StockTransaction>> getAllTransactions() {
        List transactions = this.stockTransactionService.getAllTransactions();
        if (transactions.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)transactions, (HttpStatusCode)HttpStatus.OK);
    }
}

