/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.Sale;
import com.franchise.Service.SaleService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sale"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class SaleController {
    @Autowired
    private SaleService saleService;

    @PostMapping(value={"/save"})
    public ResponseEntity<Sale> createSale(@RequestBody Sale sale) {
        Sale newSale = this.saleService.createSale(sale);
        return ResponseEntity.ok((Object)newSale);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Sale>> getAllSales() {
        List sales = this.saleService.getAllSales();
        if (sales == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(new ArrayList());
        }
        return ResponseEntity.ok((Object)sales);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Sale> getSaleById(@PathVariable Long id) {
        Optional sale = this.saleService.getSaleById(id);
        return sale.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Sale> updateSale(@PathVariable Long id, @RequestBody Sale saleDetails) {
        try {
            Sale updatedSale = this.saleService.updateSale(id, saleDetails);
            return ResponseEntity.ok((Object)updatedSale);
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteSale(@PathVariable Long id) {
        try {
            this.saleService.deleteSale(id);
            return ResponseEntity.noContent().build();
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @GetMapping(value={"/getAllOrderIds"})
    public ResponseEntity<List<String>> getAllOrderIds() {
        List orderIds = this.saleService.getAllOrderIds();
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getSaleDataById/{id}"})
    public ResponseEntity<Sale> getSaleDataById(@PathVariable String id) {
        Optional order = this.saleService.getSaleOrderById(id);
        return order.map(value -> new ResponseEntity(value, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }
}

