/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.PurchasePoOrder;
import com.franchise.Service.PurchasePoOrderService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/purchase-po-order"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class PurchasePoOrderController {
    @Autowired
    private PurchasePoOrderService purchasePoOrderService;

    @PostMapping(value={"/save"})
    public ResponseEntity<PurchasePoOrder> createPurchase(@RequestBody PurchasePoOrder purchasePoOrder) {
        PurchasePoOrder savedOrderPurchase = this.purchasePoOrderService.savePurchasePoOrder(purchasePoOrder);
        return new ResponseEntity((Object)savedOrderPurchase, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<PurchasePoOrder>> getAllPurchases() {
        List orders = this.purchasePoOrderService.getAllPurchasePoOrders();
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Optional<PurchasePoOrder>> getPurchaseOrderById(@PathVariable Long id) {
        Optional orders = this.purchasePoOrderService.getPurchasePoOrderById(id);
        return orders.isPresent() ? new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<PurchasePoOrder> updatePurchasePoOrder(@PathVariable Long id, @RequestBody PurchasePoOrder updatedPurchasePoOrder) {
        PurchasePoOrder updatedOrder = this.purchasePoOrderService.updatePurchasePoOrder(id, updatedPurchasePoOrder);
        if (updatedOrder != null) {
            return ResponseEntity.ok((Object)updatedOrder);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePurchaseOrder(@PathVariable Long id) {
        this.purchasePoOrderService.deletePurchasePoOrder(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/getAllOrderIds"})
    public ResponseEntity<List<String>> getAllOrderIds() {
        List orderIds = this.purchasePoOrderService.getAllOrderIds();
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }
}

