/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.PurchaseOrder;
import com.franchise.Service.PurchaseOrderService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/purchaseorder"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class PurchaseOrderController {
    @Autowired
    private PurchaseOrderService purchaseOrderService;

    @PostMapping(value={"/save"})
    public ResponseEntity<PurchaseOrder> createPurchase(@RequestBody PurchaseOrder purchaseOrder) {
        PurchaseOrder savedOrderPurchase = this.purchaseOrderService.savePurchaseOrder(purchaseOrder);
        return new ResponseEntity((Object)savedOrderPurchase, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<PurchaseOrder>> getAllPurchases() {
        List orders = this.purchaseOrderService.getAllPurchaseOrders();
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Optional<PurchaseOrder>> getPurchaseOrderById(@PathVariable Long id) {
        Optional orders = this.purchaseOrderService.getPurchaseOrderById(id);
        return orders.isPresent() ? new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<PurchaseOrder> updatePurchaseOrder(@PathVariable Long id, @RequestBody PurchaseOrder purchaseOrder) {
        PurchaseOrder updatedOrder = this.purchaseOrderService.updatePurchaseOrder(id, purchaseOrder);
        return updatedOrder != null ? new ResponseEntity((Object)updatedOrder, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePurchaseOrder(@PathVariable Long id) {
        this.purchaseOrderService.deletePurchaseOrder(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/getAllOrderIds"})
    public ResponseEntity<List<String>> getAllOrderIds() {
        List orderIds = this.purchaseOrderService.getAllOrderIds();
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getPoDataById/{id}"})
    public ResponseEntity<PurchaseOrder> getPurchaseOrderByPoId(@PathVariable String id) {
        Optional order = this.purchaseOrderService.getPurchaseOrderByPoId(id);
        return order.map(value -> new ResponseEntity(value, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/getOrderIdsByStatus/{status}"})
    public ResponseEntity<List<String>> getOrderIdsByStatus(@PathVariable Long status) {
        List orderIds = this.purchaseOrderService.getPurchaseOrderIdsByStatus(status);
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }

    @PutMapping(value={"/updateStatus/{id}"})
    public ResponseEntity<PurchaseOrder> updatePurchaseStatus(@PathVariable Long id, @RequestBody PurchaseOrder updatedStatus) {
        Optional existingOrder = this.purchaseOrderService.getPurchaseOrderById(id);
        if (existingOrder.isPresent()) {
            PurchaseOrder purchaseOrder = (PurchaseOrder)existingOrder.get();
            purchaseOrder.setStatus(updatedStatus.getStatus());
            PurchaseOrder updatedOrder = this.purchaseOrderService.savePurchaseOrder(purchaseOrder);
            return new ResponseEntity((Object)updatedOrder, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/getPendingOrders"})
    public ResponseEntity<List<PurchaseOrder>> getPendingOrders() {
        List pendingOrders = this.purchaseOrderService.getPendingOrders();
        return new ResponseEntity((Object)pendingOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getAcceptedOrders"})
    public ResponseEntity<List<PurchaseOrder>> getAcceptedOrders() {
        List acceptedOrders = this.purchaseOrderService.getAcceptedOrders();
        return new ResponseEntity((Object)acceptedOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getRejectedOrders"})
    public ResponseEntity<List<PurchaseOrder>> getRejectedOrders() {
        List rejectedOrders = this.purchaseOrderService.getRejectedOrders();
        return new ResponseEntity((Object)rejectedOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getShipOrders"})
    public ResponseEntity<List<PurchaseOrder>> getShipOrders() {
        List shipOrders = this.purchaseOrderService.getShipOrders();
        return new ResponseEntity((Object)shipOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getTotalShippedItems/{purchaseOrderId}"})
    public ResponseEntity<Long> getTotalShippedItems(@PathVariable String purchaseOrderId) {
        Long totalShippedItems = this.purchaseOrderService.getTotalShippedItems(purchaseOrderId);
        return ResponseEntity.ok((Object)totalShippedItems);
    }
}

