/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.ProductStock;
import com.franchise.Service.ProductStockService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/product-stock"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class ProductStockController {
    @Autowired
    private ProductStockService productStockService;

    @PostMapping(value={"/save"})
    public ResponseEntity<?> saveProductStock(@RequestBody List<ProductStock> productStocks) {
        this.productStockService.addProductStock(productStocks);
        return ResponseEntity.ok((Object)"Product stock saved successfully.");
    }

    @PutMapping(value={"/update/{productId}/{variationId}"})
    public ResponseEntity<ProductStock> updateProductStock(@PathVariable Long productId, @PathVariable Long variationId, @RequestBody ProductStock productStock) {
        ProductStock updatedStock = this.productStockService.updateProductStock(productId, variationId, productStock);
        return ResponseEntity.ok((Object)updatedStock);
    }

    @DeleteMapping(value={"/delete/{productId}/{variationId}"})
    public ResponseEntity<String> deleteProductStock(@PathVariable Long productId, @PathVariable Long variationId) {
        this.productStockService.deleteProductStock(productId, variationId);
        return ResponseEntity.ok((Object)("Product stock deleted successfully for productId: " + productId + " and variationId: " + variationId));
    }

    @GetMapping(value={"/get/{productId}/{variationId}"})
    public ResponseEntity<ProductStock> getProductStockByProductIdAndVariationId(@PathVariable Long productId, @PathVariable Long variationId) {
        ProductStock productStock = this.productStockService.getProductStockByProductIdAndVariationId(productId, variationId);
        return ResponseEntity.ok((Object)productStock);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<ProductStock>> getAllProductStock() {
        List productStocks = this.productStockService.getAllProductStock();
        return ResponseEntity.ok((Object)productStocks);
    }

    @GetMapping(value={"/by-product/{productId}"})
    public ResponseEntity<List<ProductStock>> getProductStockByProductId(@PathVariable Long productId) {
        List productStocks = this.productStockService.getProductStockByProductId(productId);
        return ResponseEntity.ok((Object)productStocks);
    }

    @GetMapping(value={"/getstock/{variationId}"})
    public ResponseEntity<Long> getTotalStockByVariationId(@PathVariable Long variationId) {
        Long totalStock = this.productStockService.getTotalStockByVariationId(variationId);
        return ResponseEntity.ok((Object)totalStock);
    }
}

