/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.PaymentMethod;
import com.franchise.Service.PaymentMethodService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payment-method"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class PaymentMethodController {
    @Autowired
    private PaymentMethodService paymentMethodService;

    @PostMapping(value={"/save"})
    public ResponseEntity<PaymentMethod> savePermission(@RequestBody PaymentMethod paymentMethod) {
        PaymentMethod savedPay = this.paymentMethodService.savePaymentMethod(paymentMethod);
        return new ResponseEntity((Object)savedPay, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<PaymentMethod>> getAllPermissions() {
        List payment = this.paymentMethodService.getAllPaymentMethod();
        return new ResponseEntity((Object)payment, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PaymentMethod> getPermissionById(@PathVariable Long id) {
        Optional payment = this.paymentMethodService.getPaymentMethod(id);
        if (payment.isPresent()) {
            return new ResponseEntity((Object)((PaymentMethod)payment.get()), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/active-names"})
    public ResponseEntity<List<String>> getAllActivePaymentMethodNames() {
        List activePaymentNames = this.paymentMethodService.getAllActivePaymentMethodNames();
        return new ResponseEntity((Object)activePaymentNames, (HttpStatusCode)HttpStatus.OK);
    }

    @PutMapping(value={"/update-status/{id}"})
    public ResponseEntity<String> updatePaymentMethodStatus(@PathVariable Long id, @RequestParam boolean isActive) {
        this.paymentMethodService.updatePaymentMethodStatus(id, isActive);
        return new ResponseEntity((Object)"Payment method status updated successfully.", (HttpStatusCode)HttpStatus.OK);
    }
}

