/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.PaymentAccount;
import com.franchise.Entity.Transaction;
import com.franchise.Service.PaymentAccountService;
import com.franchise.ServiceImpl.PaymentAccountServiceImpl;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payment-account"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class PaymentAccountController {
    @Autowired
    private PaymentAccountService paymentAccountService;
    @Autowired
    private PaymentAccountServiceImpl paymentAccountServiceImpl;

    @PostMapping(value={"/save"})
    public ResponseEntity<PaymentAccount> savePaymentAccount(@RequestBody PaymentAccount paymentAccount) {
        PaymentAccount payment = this.paymentAccountService.savePaymentAccount(paymentAccount);
        return new ResponseEntity((Object)payment, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/{accountId}"})
    public ResponseEntity<Transaction> createTransaction(@PathVariable Long accountId, @RequestBody Transaction transactionRequest) {
        try {
            Transaction savedTransaction = this.paymentAccountService.createTransaction(accountId, transactionRequest);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)savedTransaction);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
    }

    @GetMapping(value={"/balance/{id}"})
    public ResponseEntity<BigDecimal> getCurrentBalance(@PathVariable Long id) {
        BigDecimal balance = this.paymentAccountService.getCurrentBalance(id);
        return ResponseEntity.ok((Object)balance);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<PaymentAccount>> getAllPaymentAccount() {
        List payment = this.paymentAccountService.getAllPaymentAccounts();
        return new ResponseEntity((Object)payment, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<PaymentAccount> getPaymentAccountById(@PathVariable Long id) {
        Optional payment = this.paymentAccountService.getPaymentAccountById(id);
        return payment.map(account -> new ResponseEntity(account, (HttpStatusCode)HttpStatus.OK)).orElse(new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<PaymentAccount> updatePaymentAccount(@PathVariable Long id, @RequestBody PaymentAccount paymentAccount) {
        PaymentAccount updatedAccount = this.paymentAccountService.updatePaymentAccount(id, paymentAccount);
        if (updatedAccount != null) {
            return new ResponseEntity((Object)updatedAccount, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePaymentAccount(@PathVariable Long id) {
        this.paymentAccountService.deletePaymentAccount(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @PutMapping(value={"/transaction/update/{transactionId}"})
    public ResponseEntity<Transaction> updateTransaction(@PathVariable Long transactionId, @RequestBody Transaction transactionRequest) {
        try {
            Transaction updatedTransaction = this.paymentAccountService.updateTransaction(transactionId, transactionRequest.getAmount(), transactionRequest.getPaymentMethod(), transactionRequest.getTransactionType(), transactionRequest.getAddedBy(), transactionRequest.getNote(), transactionRequest.getDate(), transactionRequest.getVendor());
            return new ResponseEntity((Object)updatedTransaction, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @PutMapping(value={"/update-status/{id}"})
    public ResponseEntity<String> updateAccountStatus(@PathVariable Long id, @RequestParam Long status) {
        try {
            this.paymentAccountService.updateAccountStatus(id, status);
            return ResponseEntity.ok((Object)"Account status updated successfully");
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Payment account not found");
        }
    }

    @GetMapping(value={"/getbyvendor/{vendor}"})
    public ResponseEntity<Map<String, List<Object>>> getPaymentByVendor(@PathVariable String vendor) {
        Map orders = this.paymentAccountServiceImpl.getPaymentByVendor(vendor);
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }
}

