/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.User;
import com.backend.Repository.UserRepo;
import com.backend.Service.UserService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserRepo userrepo;

    public User saveUser(User user) {
        return (User)this.userrepo.save((Object)user);
    }

    public Optional<User> findByEmail(String email) {
        return this.userrepo.findByEmail(email);
    }

    public boolean isActiveUser(String email) {
        Optional userOpt = this.userrepo.findByEmail(email);
        return userOpt.isPresent() && ((User)userOpt.get()).getIsActive() != false;
    }

    public boolean authenticate(String email, String password) {
        Optional userOpt = this.userrepo.findByEmail(email);
        return userOpt.isPresent() && ((User)userOpt.get()).getPassword().equals(password) && ((User)userOpt.get()).getIsActive() != false;
    }

    public List<User> getallusers() {
        return this.userrepo.findAll();
    }

    public Optional<User> findById(Long id) {
        return this.userrepo.findById((Object)id);
    }

    public Optional<User> updateUser(Long id, User user) {
        return this.userrepo.findById((Object)id).map(existingUser -> {
            existingUser.setPrefix(user.getPrefix());
            existingUser.setFirstname(user.getFirstname());
            existingUser.setLastname(user.getLastname());
            existingUser.setEmail(user.getEmail());
            existingUser.setIsActive(user.getIsActive());
            existingUser.setUsername(user.getUsername());
            existingUser.setPassword(user.getPassword());
            existingUser.setAllowLogin(user.getAllowLogin());
            existingUser.setLocation(user.getLocation());
            existingUser.setEnableServiceStaffPin(user.isEnableServiceStaffPin());
            existingUser.setStaffPin(user.getStaffPin());
            existingUser.setSalesCommissionPercentage(user.getSalesCommissionPercentage());
            existingUser.setCommisionPercent(user.getCommisionPercent());
            existingUser.setAllowContacts(user.getAllowContacts());
            existingUser.setSelectedContacts(user.getSelectedContacts());
            existingUser.setLanguage(user.getLanguage());
            existingUser.setDateOfBirth(user.getDateOfBirth());
            existingUser.setGender(user.getGender());
            existingUser.setMaritalStatus(user.getMaritalStatus());
            existingUser.setBloodGroup(user.getBloodGroup());
            existingUser.setMobileNumber(user.getMobileNumber());
            existingUser.setAlternateContactNumber(user.getAlternateContactNumber());
            existingUser.setFamilyContactNumber(user.getFamilyContactNumber());
            existingUser.setFacebookLink(user.getFacebookLink());
            existingUser.setTwitterLink(user.getTwitterLink());
            existingUser.setSocialMedia1(user.getSocialMedia1());
            existingUser.setSocialMedia2(user.getSocialMedia2());
            existingUser.setCustomField1(user.getCustomField1());
            existingUser.setCustomField2(user.getCustomField2());
            existingUser.setCustomField3(user.getCustomField3());
            existingUser.setCustomField4(user.getCustomField4());
            existingUser.setGuardianName(user.getGuardianName());
            existingUser.setIdProofName(user.getIdProofName());
            existingUser.setIdProofNumber(user.getIdProofNumber());
            existingUser.setPermanentAddress(user.getPermanentAddress());
            existingUser.setCurrentAddress(user.getCurrentAddress());
            existingUser.setDepartmentId(user.getDepartmentId());
            existingUser.setDesignationId(user.getDesignationId());
            existingUser.setPrimaryWorkLocation(user.getPrimaryWorkLocation());
            existingUser.setBasicSalary(user.getBasicSalary());
            existingUser.setSalaryIn(user.getSalaryIn());
            existingUser.setPayComponentId(user.getPayComponentId());
            existingUser.setAccountHolderName(user.getAccountHolderName());
            existingUser.setAccountNumber(user.getAccountNumber());
            existingUser.setBankName(user.getBankName());
            existingUser.setIfsc(user.getIfsc());
            existingUser.setBranch(user.getBranch());
            existingUser.setTaxPayerId(user.getTaxPayerId());
            existingUser.setRoles(user.getRoles());
            return (User)this.userrepo.save(existingUser);
        });
    }

    public boolean deleteUser(Long id) {
        if (this.userrepo.existsById((Object)id)) {
            this.userrepo.deleteById((Object)id);
            return true;
        }
        return false;
    }

    public User getUserWithRolesAndPermissions(String email) {
        List users = this.userrepo.findByEmailItsPermissions(email);
        if (users.size() == 1) {
            return (User)users.get(0);
        }
        if (users.isEmpty()) {
            return null;
        }
        throw new IllegalStateException("Multiple users found with username: " + email);
    }

    public Optional<String> getUserName(String email) {
        return this.userrepo.getUsernameByEmail(email);
    }
}

