/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.Sale;
import com.backend.Entity.SalePaymentMethod;
import com.backend.Repository.SalePaymentMethodRepo;
import com.backend.Repository.SaleRepo;
import com.backend.Service.SaleService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleServiceImpl
implements SaleService {
    @Autowired
    private SaleRepo saleRepo;
    @Autowired
    private SalePaymentMethodRepo salePaymentMethodRepo;

    public Sale createSale(Sale sale) {
        if (sale.getSalePaymentMethod() != null && sale.getSalePaymentMethod().getId() == null) {
            SalePaymentMethod savedPaymentMethod = (SalePaymentMethod)this.salePaymentMethodRepo.save((Object)sale.getSalePaymentMethod());
            sale.setSalePaymentMethod(savedPaymentMethod);
        }
        return (Sale)this.saleRepo.save((Object)sale);
    }

    public List<Sale> getAllSales() {
        return this.saleRepo.findAll();
    }

    public Optional<Sale> getSaleById(Long id) {
        return this.saleRepo.findById((Object)id);
    }

    public Sale updateSale(Long id, Sale saleDetails) {
        Optional existingSale = this.saleRepo.findById((Object)id);
        if (existingSale.isPresent()) {
            Sale sale = (Sale)existingSale.get();
            if (saleDetails.getSalePaymentMethod() != null && saleDetails.getSalePaymentMethod().getId() == null) {
                SalePaymentMethod savedPaymentMethod = (SalePaymentMethod)this.salePaymentMethodRepo.save((Object)saleDetails.getSalePaymentMethod());
                sale.setSalePaymentMethod(savedPaymentMethod);
            } else {
                sale.setSalePaymentMethod(saleDetails.getSalePaymentMethod());
            }
            sale.setCustomer(saleDetails.getCustomer());
            sale.setPayTermNumber(saleDetails.getPayTermNumber());
            sale.setPayTermType(saleDetails.getPayTermType());
            sale.setSaleDate(saleDetails.getSaleDate());
            sale.setStatus(saleDetails.getStatus());
            sale.setInvoiceScheme(saleDetails.getInvoiceScheme());
            sale.setInvoiceNo(saleDetails.getInvoiceNo());
            sale.setDiscountType(saleDetails.getDiscountType());
            sale.setDiscountAmount(saleDetails.getDiscountAmount());
            sale.setOrderTax(saleDetails.getOrderTax());
            sale.setTaxAmount(saleDetails.getTaxAmount());
            sale.setSaleNotes(saleDetails.getSaleNotes());
            sale.setShippingDetails(saleDetails.getShippingDetails());
            sale.setShippingCharges(saleDetails.getShippingCharges());
            sale.setShippingStatus(saleDetails.getShippingStatus());
            sale.setDeliveredTo(saleDetails.getDeliveredTo());
            sale.setDeliveryPerson(saleDetails.getDeliveryPerson());
            return (Sale)this.saleRepo.save((Object)sale);
        }
        throw new RuntimeException("Sale not found with id " + id);
    }

    public void deleteSale(Long id) {
        if (!this.saleRepo.existsById((Object)id)) {
            throw new RuntimeException("Sale not found with id " + id);
        }
        this.saleRepo.deleteById((Object)id);
    }
}

