/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Entity;

import com.backend.Entity.TaxRate;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="tax_groups")
public class TaxGroup {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String name;
    @Transient
    private String groupTaxRate;
    private String SubTaxes;
    @ManyToMany
    @JoinTable(name="tax_group_tax_rate", joinColumns={@JoinColumn(name="tax_group_id")}, inverseJoinColumns={@JoinColumn(name="tax_rate_id")})
    private List<TaxRate> taxRates = new ArrayList();
    @Transient
    private List<Long> taxRatesIds;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<TaxRate> getTaxRates() {
        return this.taxRates;
    }

    public void setTaxRates(List<TaxRate> taxRates) {
        this.taxRates = taxRates;
    }

    public List<Long> getTaxRatesIds() {
        return this.taxRatesIds;
    }

    public void setTaxRatesIds(List<Long> taxRatesIds) {
        this.taxRatesIds = taxRatesIds;
    }

    public String getGroupTaxRate() {
        double totalRate = 0.0;
        for (TaxRate taxRate : this.taxRates) {
            totalRate += taxRate.getTaxRate().doubleValue();
        }
        return String.format("%.2f", totalRate);
    }

    public void setGroupTaxRate(String groupTaxRate) {
        this.groupTaxRate = groupTaxRate;
    }

    public String getSubTaxes() {
        StringBuilder subTaxesBuilder = new StringBuilder();
        for (TaxRate taxRate : this.taxRates) {
            if (subTaxesBuilder.length() > 0) {
                subTaxesBuilder.append(", ");
            }
            subTaxesBuilder.append(taxRate.getName());
        }
        return subTaxesBuilder.toString();
    }

    public void setSubTaxes(String subTaxes) {
        this.SubTaxes = subTaxes;
    }
}

