/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.LoginRequest;
import com.backend.Entity.Vendor;
import com.backend.Service.VendorService;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vendor"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class VendorController {
    @Autowired
    private VendorService vendorService;

    @PostMapping(value={"/save"})
    public ResponseEntity<Vendor> createVendor(@RequestBody Vendor vendor) {
        Vendor savedVendor = this.vendorService.saveVendor(vendor);
        return ResponseEntity.ok((Object)savedVendor);
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<String> login(@RequestBody LoginRequest request, HttpSession session) {
        boolean isAuthenticated = this.vendorService.authenticate(request.getEmail(), request.getPassword());
        if (isAuthenticated) {
            session.setAttribute("userEmail", (Object)request.getEmail());
            return new ResponseEntity((Object)"Login successful", (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)"Invalid credentials or account inactive", (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    @PostMapping(value={"/logout"})
    public ResponseEntity<String> logout(HttpSession session) {
        session.invalidate();
        return new ResponseEntity((Object)"Logout successful", (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Vendor>> getAllVendors() {
        List vendors = this.vendorService.getAllVendors();
        return ResponseEntity.ok((Object)vendors);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Vendor> getVendorById(@PathVariable Long id) {
        Vendor vendor = this.vendorService.getVendorById(id);
        if (vendor != null) {
            return ResponseEntity.ok((Object)vendor);
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Vendor> updateVendor(@PathVariable Long id, @RequestBody Vendor updatedVendor) {
        Vendor vendor = this.vendorService.updateVendor(id, updatedVendor);
        if (vendor != null) {
            return ResponseEntity.ok((Object)vendor);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteVendorById(@PathVariable Long id) {
        this.vendorService.deleteVendorById(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/firmname/email/{email}"})
    public ResponseEntity<Map<String, String>> getFirmNameByEmail(@PathVariable String email) {
        Optional firmName = this.vendorService.findFirmNameByEmail(email);
        if (firmName.isPresent()) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("firmName", (String)firmName.get());
            return ResponseEntity.ok(response);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/check-email"})
    public ResponseEntity<String> checkVendorEmail(@RequestParam String email) {
        Optional vendorExists = this.vendorService.findByEmail(email);
        if (vendorExists.isPresent()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"Email exists");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Email does not exist");
    }

    @GetMapping(value={"/check-vendorid"})
    public ResponseEntity<String> checkVendorId(@RequestParam String vendorId) {
        Optional vendorExists = this.vendorService.findByVendorId(vendorId);
        if (vendorExists.isPresent()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"Vendor ID exists");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Vendor ID does not exist");
    }

    @PutMapping(value={"/toggle-active/{id}"})
    public ResponseEntity<Map<String, Object>> toggleVendorActiveStatus(@PathVariable Long id, @RequestParam boolean isActive) {
        Vendor updatedVendor = this.vendorService.toggleActiveStatus(id, isActive);
        if (updatedVendor != null) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("message", "Vendor status updated");
            response.put("isActive", updatedVendor.getIsActive());
            return ResponseEntity.ok(response);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(Map.of("message", "Vendor not found"));
    }

    @GetMapping(value={"/getallactive"})
    public ResponseEntity<List<Vendor>> getAllActiveVendors() {
        List activeVendors = this.vendorService.getAllActiveVendors();
        return ResponseEntity.ok((Object)activeVendors);
    }

    @GetMapping(value={"/getallinactive"})
    public ResponseEntity<List<Vendor>> getAllInactiveVendors() {
        List inactiveVendors = this.vendorService.getAllInactiveVendors();
        return ResponseEntity.ok((Object)inactiveVendors);
    }
}

