/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.StockAdjustment;
import com.backend.Service.StockAdjustmentService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/stock-adjustments"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class StockAdjustmentController {
    @Autowired
    private StockAdjustmentService stockAdjustmentService;

    @PostMapping(value={"/save"})
    public ResponseEntity<StockAdjustment> saveStockAdjustment(@RequestBody StockAdjustment stockAdjustment) {
        try {
            StockAdjustment savedStockAdjustment = this.stockAdjustmentService.saveStockAdjustment(stockAdjustment);
            return new ResponseEntity((Object)savedStockAdjustment, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<StockAdjustment>> getAllStockAdjustments() {
        try {
            List stockAdjustments = this.stockAdjustmentService.getAllStockAdjustments();
            if (stockAdjustments.isEmpty()) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
            }
            return new ResponseEntity((Object)stockAdjustments, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<StockAdjustment> getStockAdjustmentById(@PathVariable(value="id") Long id) {
        Optional stockAdjustment = this.stockAdjustmentService.getStockAdjustmentById(id);
        return stockAdjustment.map(stock -> new ResponseEntity(stock, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<StockAdjustment> updateStockAdjustment(@PathVariable(value="id") Long id, @RequestBody StockAdjustment stockAdjustment) {
        try {
            StockAdjustment updatedStockAdjustment = this.stockAdjustmentService.updateStockAdjustment(id, stockAdjustment);
            return new ResponseEntity((Object)updatedStockAdjustment, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<HttpStatus> deleteStockAdjustment(@PathVariable(value="id") Long id) {
        try {
            this.stockAdjustmentService.deleteStockAdjustment(id);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (Exception e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }
}

