/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Shift;
import com.backend.Service.ShiftService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/shift"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class ShiftController {
    @Autowired
    private ShiftService shiftService;

    @PostMapping(value={"/add"})
    public ResponseEntity<Shift> saveShift(@RequestBody Shift shift) {
        Shift createdShift = this.shiftService.saveShift(shift);
        return new ResponseEntity((Object)createdShift, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Shift>> getAllShifts() {
        List shifts = this.shiftService.getAllShifts();
        return new ResponseEntity((Object)shifts, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Shift> getShiftById(@PathVariable Long id) {
        Shift shift = this.shiftService.getShiftById(id);
        if (shift != null) {
            return new ResponseEntity((Object)shift, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Shift> updateShift(@PathVariable Long id, @RequestBody Shift updatedShift) {
        Shift shift = this.shiftService.updateShift(id, updatedShift);
        if (shift != null) {
            return new ResponseEntity((Object)shift, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteShiftById(@PathVariable Long id) {
        this.shiftService.deleteShiftById(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

